<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\BrancheModel;
use Psr\Log\LoggerInterface;
use stdClass;

class BrancheController extends BaseController
{
    public BrancheModel $brancheModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->brancheModel = new BrancheModel();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/branche/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/branche/save";
        $this->viewData['branche'] =  $this->initBranche($id);

        return view('params/branche/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/branche/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/branche/save";
            $this->viewData['branche'] =  $this->initBranche($id);

            return view('params/branche/add', $this->viewData);
        } else {

            $uneBranche = $this->uneBranche();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Une province <b>" . $uneBranche['description'] . "</b> a été modifiée</div>");
                $stmt = $this->brancheModel->update($id, $uneBranche);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Une province <b>" . $uneBranche['description'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->brancheModel->save($uneBranche);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/branche'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->brancheModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La province a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/branche'));
        }
        
    }

    private function uneBranche()
    {
        $branche = [];
        $branche['description'] = $this->request->getPost('description');
        $branche['longitude'] = $this->request->getPost('longitude');
        $branche['latitude'] = $this->request->getPost('latitude');

        return $branche;
    }

    private function initBranche($id = NULL)
    {
        $branche = NULL;
        if ($id) {
            $branche = $this->brancheModel->find($id);
        } else {
            $branche = new stdClass();
            $branche->id = 0;
            $branche->description = "";
            $branche->longitude = "-1.0";
            $branche->latitude = "-1.0";
        }

        return $branche;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['longitude'] = ['rules'  => 'permit_empty|decimal'];
        $rules['latitude'] = ['rules'  => 'permit_empty|decimal'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description', 'latitude', 'longitude'];
        $order_column = ['id', 'description', 'latitude', 'longitude'];

        $fetch_data = DatatableQuery::build_query($this->brancheModel, $search_column, $order_column);
        $output = $this->formatBranches($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatBranches($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $sub_array[] =  $data->latitude;
                $sub_array[] =  $data->longitude;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/branche/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/branche/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
