<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\DomaineActiviteModel;
use Psr\Log\LoggerInterface;
use stdClass;

class DomaineActiviteController extends BaseController
{
    public DomaineActiviteModel $domaineActiviteModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->domaineActiviteModel = new DomaineActiviteModel();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/domaineActivite/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/domaineActivite/save";
        $this->viewData['domaineActivite'] =  $this->initDomaineActivite($id);

        return view('params/domaineActivite/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/domaineActivite/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/domaineActivite/save";
            $this->viewData['domaineActivite'] =  $this->initDomaineActivite($id);

            return view('params/domaineActivite/add', $this->viewData);
        } else {

            $uneDomaineActivite = $this->uneDomaineActivite();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un domaine d\'activite <b>" . $uneDomaineActivite['description'] . "</b> a été modifiée</div>");
                $stmt = $this->domaineActiviteModel->update($id, $uneDomaineActivite);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un domaine d\'activite <b>" . $uneDomaineActivite['description'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->domaineActiviteModel->save($uneDomaineActivite);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/domaineActivite'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->domaineActiviteModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un domaine d\'activite a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/domaineActivite'));
        }
        
    }

    private function uneDomaineActivite()
    {
        $branche = [];
        $branche['description'] = $this->request->getPost('description');

        return $branche;
    }

    private function initDomaineActivite($id = NULL)
    {
        $branche = NULL;
        if ($id) {
            $branche = $this->domaineActiviteModel->find($id);
        } else {
            $branche = new stdClass();
            $branche->id = 0;
            $branche->description = "";
        }

        return $branche;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->domaineActiviteModel, $search_column, $order_column);
        $output = $this->formatDomaineActivite($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatDomaineActivite($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/domaineActivite/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/domaineActivite/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
