<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\TypeFormationModel;
use Psr\Log\LoggerInterface;
use stdClass;

class TypeFormationController extends BaseController
{
    public TypeFormationModel $typeFormationModel;
    
    function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->typeFormationModel = new TypeFormationModel();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/typeFormation/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/typeFormation/save";
        $this->viewData['typeFormation'] =  $this->initTypeFormation($id);

        return view('params/typeFormation/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/typeFormation/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/typeFormation/save";
            $this->viewData['typeFormation'] =  $this->initTypeFormation($id);

            return view('params/typeFormation/add', $this->viewData);
        } else {

            $unTypeFormation = $this->unTypeFormation();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type de formation <b>" . $unTypeFormation['description'] . "</b> a été modifié</div>");
                $stmt = $this->typeFormationModel->update($id, $unTypeFormation);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type de formation <b>" . $unTypeFormation['description'] . "</b> a été bien enregistré</div>");
                $stmt = $this->typeFormationModel->save($unTypeFormation);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/typeFormation'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->typeFormationModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type de formation a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/typeFormation'));
        }
        
    }

    private function unTypeFormation()
    {
        $typeFormation = [];
        $typeFormation['description'] = $this->request->getPost('description');

        return $typeFormation;
    }

    private function initTypeFormation($id = NULL)
    {
        $typeFormation = NULL;
        if ($id) {
            $typeFormation = $this->typeFormationModel->find($id);
        } else {
            $typeFormation = new stdClass();
            $typeFormation->id = 0;
            $typeFormation->description = "";
        }

        return $typeFormation;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->typeFormationModel, $search_column, $order_column);
        $output = $this->formatTypeFormation($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatTypeFormation($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/typeFormation/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/typeFormation/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
