<?php

namespace Modules\Formation\Config;

// Create a new instance of our RouteCollection class.
$routes->group("{locale}/data", ["namespace" => "\Modules\data\Controllers", 'filter' => ['appAuth']], function ($routes) {
    
    //Routes for vulnerable
    $routes->get("vulnerable", "VulnerableController::index");
    $routes->get("vulnerable/add", "VulnerableController::add");
    $routes->get("vulnerable/add/(:num)", "VulnerableController::add");
    $routes->post("vulnerable/save", "VulnerableController::save");
    $routes->post("vulnerable/data", "VulnerableController::fecth");
    $routes->get("vulnerable/delete/(:num)", "VulnerableController::delete");
    $routes->get("vulnerable/export/(:num)", "VulnerableController::export");


    //Routes for etat des lieux
    $routes->get("etat", "EtatLieuController::index");
    $routes->get("etat/add", "EtatLieuController::add");
    $routes->get("etat/add/(:num)", "EtatLieuController::add");
    $routes->post("etat/save", "EtatLieuController::save");
    $routes->post("etat/data", "EtatLieuController::fecth");
    $routes->get("etat/delete/(:num)", "EtatLieuController::delete");
    $routes->get("etat/export/(:num)", "EtatLieuController::export");

    //Routes for Infrastructure
    $routes->get("infrastructure", "InfrastructureController::index");
    $routes->get("infrastructure/add", "InfrastructureController::add");
    $routes->get("infrastructure/add/(:num)", "InfrastructureController::add");
    $routes->post("infrastructure/save", "InfrastructureController::save");
    $routes->post("infrastructure/data", "InfrastructureController::fecth");
    $routes->get("infrastructure/delete/(:num)", "InfrastructureController::delete");
    $routes->get("infrastructure/export/(:num)", "InfrastructureController::export");

    //Routes for Ambulance
    $routes->get("ambulance", "AmbulanceController::index");
    $routes->get("ambulance/add", "AmbulanceController::add");
    $routes->get("ambulance/add/(:num)", "AmbulanceController::add/$1");
    $routes->post("ambulance/save", "AmbulanceController::save");
    $routes->post("ambulance/staff", "AmbulanceController::saveStaff");
    $routes->post("ambulance/data", "AmbulanceController::fecth");
    $routes->get("ambulance/delete/(:num)", "AmbulanceController::delete");
    $routes->get("ambulance/staff/(:num)", "AmbulanceController::deleteStaff");
    $routes->get("ambulance/export/(:num)", "AmbulanceController::export");
    
});
