<?php

namespace Modules\data\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\data\Models\AmbulanceModel;
use Modules\data\Models\AmbulanceStaffModel;
use Modules\Params\Models\BrancheModel;
use Modules\Params\Models\CommuneModel;
use Modules\Params\Models\TypeStaff;
use Psr\Log\LoggerInterface;
use stdClass;
use UConverter;

use function PHPUnit\Framework\fileExists;

class AmbulanceController extends BaseController
{
    public AmbulanceModel $ambulanceModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->ambulanceModel = new AmbulanceModel();
    }

    public function index()
    {
        $this->viewData['url_list'] = "/data/ambulance/data";
        $this->viewData['js'] = "Common.js";
        $this->viewData['title'] = "Liste des services ambulanciers";
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());

        return view('data/ambulance/index', $this->viewData);
    }

    public function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "Volontaire.js";
        $this->viewData['route'] = "/data/ambulance/save";
        $this->viewData['routeStaff'] = "/data/ambulance/staff";
        $this->viewData['ambulance'] =  $this->initAmbulance($id);
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        $this->viewData['staffs'] = CommonTrait::formatData(new TypeStaff());
        $this->viewData['typeEvacuations'] = CommonTrait::typeEvacuations();
        $this->viewData['modeEvacuations'] = CommonTrait::modeEvacuations();
        $this->viewData['genres'] = CommonTrait::genres();

        if ($id > 0) {
            $title = "Editer un service ambulancier";
            $this->viewData['membres'] = (new AmbulanceStaffModel())->where('ambulanceId', $id)->findAll();
        } else
            $title = "Nouveau service ambulancier";

        $this->viewData['title'] = $title;

        return view('data/ambulance/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/data/ambulance/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/data/ambulance/save";
            $this->viewData['routeStaff'] = "/data/ambulance/staff";
            $this->viewData['ambulance'] =  $this->initAmbulance($id);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['staffs'] = CommonTrait::formatData(new TypeStaff());
            $this->viewData['typeEvacuations'] = CommonTrait::typeEvacuations();
            $this->viewData['modeEvacuations'] = CommonTrait::modeEvacuations();
            $this->viewData['genres'] = CommonTrait::genres();

            if ($id > 0) {
                $title = "Editer un service ambulancier";
                $this->viewData['membres'] = (new AmbulanceStaffModel())->where('ambulanceId', $id)->findAll();
            } else
                $title = "Nouveau service ambulancier";

            $this->viewData['title'] = $title;

            return view('data/ambulance/add', $this->viewData);
        } else {

            $unAmbulance = $this->unAmbulance();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le service ambulancier a été modifié</div>");
                $stmt = $this->ambulanceModel->update($id, $unAmbulance);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le service ambulancier a été bien enregistré</div>");
                $id = $stmt = $this->ambulanceModel->insert($unAmbulance);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/data/ambulance/add/'.$id));
            }
        }
    }

    function saveStaff()
    {
        $rules = [];
        $rules['ambulanceId'] = ['rules'  => 'required'];
        $rules['membre'] = ['rules'  => 'required'];
        $rules['typeStaffId'] = ['rules'  => 'required'];

        $ambulanceId = $this->request->getPost('ambulanceId');

        if (!$this->validate($rules)) {
            $this->viewData['url_list'] = "/data/ambulance/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/data/ambulance/save";
            $this->viewData['routeStaff'] = "/data/ambulance/staff";
            $this->viewData['ambulance'] =  $this->initAmbulance($ambulanceId);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['staffs'] = CommonTrait::formatData(new TypeStaff());
            $this->viewData['typeEvacuations'] = CommonTrait::typeEvacuations();
            $this->viewData['modeEvacuations'] = CommonTrait::modeEvacuations();
            $this->viewData['genres'] = CommonTrait::genres();

            $title = "Editer un service ambulancier";
            $this->viewData['membres'] = (new AmbulanceStaffModel())->where('ambulanceId', $ambulanceId)->findAll();

            $this->viewData['title'] = $title;

            return view('data/ambulance/add', $this->viewData);
        } else {
            $ambulance = [];
            $ambulance['ambulanceId'] = $ambulanceId;
            $ambulance['membre'] = $this->request->getPost('membre');
            $ambulance['typeStaffId'] = $this->request->getPost('typeStaffId');

            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le membre du staff a été bien enregistré</div>");
            (new AmbulanceStaffModel())->save($ambulance);

            return redirect()->to(site_url($this->viewData['locale'] . '/data/ambulance/add/' . $ambulanceId));
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->ambulanceModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le service ambulancier a été suprimé</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/data/ambulance'));
        }
    }

    public function deleteStaff()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);
        $ambulance = (new AmbulanceStaffModel())->find($id);

        if ($ambulance) {
            (new AmbulanceStaffModel())->delete($id);

            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le membre du staff a été suprimé</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/data/ambulance/add/' . $ambulance->ambulanceId));
        }
    }

    private function unAmbulance()
    {
        $ambulance = [];
        $ambulance['brancheId'] = $this->request->getPost('brancheId');
        $ambulance['communeId'] = $this->request->getPost('communeId');
        $ambulance['zoneId'] = $this->request->getPost('zoneId');
        $ambulance['collineId'] = $this->request->getPost('collineId');
        $ambulance['numImmatriculation'] = $this->request->getPost('numImmatriculation');
        $ambulance['chauffeur'] = $this->request->getPost('chauffeur');
        $ambulance['gardeMalade'] = $this->request->getPost('gardeMalade');
        $ambulance['telephone'] = $this->request->getPost('telephone');
        $ambulance['dateDepart'] = $this->request->getPost('dateDepart');
        $ambulance['lieuEvacuation'] = $this->request->getPost('lieuEvacuation');
        $ambulance['typeEvacuationId'] = $this->request->getPost('typeEvacuationId');
        $ambulance['destinationPatient'] = $this->request->getPost('destinationPatient');
        $ambulance['patient'] = $this->request->getPost('patient');
        $ambulance['sexe'] = $this->request->getPost('sexe');
        $ambulance['agePatient'] = $this->request->getPost('agePatient');
        $ambulance['diagnostic'] = $this->request->getPost('diagnostic');
        $ambulance['modeEvacuationId'] = $this->request->getPost('modeEvacuationId');
        $ambulance['coutServiceAmbulance'] = $this->request->getPost('coutServiceAmbulance');
        $ambulance['coutDepense'] = $this->request->getPost('coutDepense');
        $ambulance['dateRetour'] = $this->request->getPost('dateRetour');
        $ambulance['userId'] = \auth()->user()->id;

        return $ambulance;
    }

    private function initAmbulance($id = NULL)
    {
        $ambulance = NULL;
        if ($id) {
            $ambulance = $this->ambulanceModel->find($id);
        } else {
            $ambulance = new stdClass();
            $ambulance->id = 0;
            $ambulance->brancheId = NULL;
            $ambulance->communeId = NULL;
            $ambulance->zoneId = NULL;
            $ambulance->collineId = NULL;
            $ambulance->numImmatriculation = '';
            $ambulance->chauffeur = NULL;
            $ambulance->gardeMalade = 0;
            $ambulance->telephone = 0;
            $ambulance->dateDepart = 0;
            $ambulance->lieuEvacuation = 0;
            $ambulance->typeEvacuationId = 0;
            $ambulance->destinationPatient = 0;
            $ambulance->patient = NULL;
            $ambulance->sexe = NULL;
            $ambulance->agePatient = NULL;
            $ambulance->diagnostic = NULL;
            $ambulance->modeEvacuationId = NULL;
            $ambulance->coutServiceAmbulance = NULL;
            $ambulance->coutDepense = NULL;
            $ambulance->dateRetour = NULL;
        }

        return $ambulance;
    }

    private function _rules()
    {
        $rules = [];
        $rules['brancheId'] = ['rules'  => 'required'];
        $rules['communeId'] = ['rules'  => 'required'];
        $rules['zoneId'] = ['rules'  => 'required'];
        $rules['collineId'] = ['rules'  => 'required'];
        $rules['numImmatriculation'] = ['rules'  => 'required'];
        $rules['chauffeur'] = ['rules'  => 'required'];
        $rules['gardeMalade'] = ['rules'  => 'required'];
        $rules['telephone'] = ['rules'  => 'required'];
        $rules['dateDepart'] = ['rules'  => 'required'];
        $rules['lieuEvacuation'] = ['rules'  => 'required'];
        $rules['typeEvacuationId'] = ['rules'  => 'required'];
        $rules['destinationPatient'] = ['rules'  => 'required'];
        $rules['patient'] = ['rules'  => 'required'];
        $rules['sexe'] = ['rules'  => 'required'];
        $rules['agePatient'] = ['rules'  => 'required'];
        $rules['diagnostic'] = ['rules'  => 'required'];
        $rules['modeEvacuationId'] = ['rules'  => 'required'];
        if ($this->request->getPost('modeEvacuationId') == 2) {
            $rules['coutServiceAmbulance'] = ['rules'  => 'required'];
        }
        $rules['coutDepense'] = ['rules'  => 'required'];
        $rules['dateRetour'] = ['rules'  => 'required'];

        return $rules;
    }

    function fecth()
    {
        $search_column = ['brancheId', 'communeId', 'zoneId', 'collineId', 'numImmatriculation', 'chauffeur', 'gardeMalade', 'telephone', 'dateDepart', 'lieuEvacuation', 'typeEvacuationId', 'destinationPatient', 'patient', 'sexe', 'agePatient', 'diagnostic', 'modeEvacuationId', 'coutServiceAmbulance', 'coutDepense', 'dateRetour'];
        $order_column = ['brancheId', 'communeId', 'zoneId', 'collineId', 'numImmatriculation', 'chauffeur', 'gardeMalade', 'telephone', 'dateDepart', 'lieuEvacuation', 'typeEvacuationId', 'destinationPatient', 'patient', 'sexe', 'agePatient', 'diagnostic', 'modeEvacuationId', 'coutServiceAmbulance', 'coutDepense', 'dateRetour'];

        $ambulanceMdl = $this->ambulanceModel;
        if (\auth()->user()->inGroup('brancheManager')) {
            $ambulanceMdl->where('brancheId', \auth()->user()->brancheId);
        }

        if (\auth()->user()->inGroup('communeManager')) {
            $ambulanceMdl->where('communeId', \auth()->user()->communeId);
        }

        if ($this->request->getPost('brancheId') > 0) {
            $ambulanceMdl->where('brancheId', $this->request->getPost('brancheId'));
        }

        $fetch_data = DatatableQuery::build_query($ambulanceMdl, $search_column, $order_column);
        $output = $this->formatAmbulances($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatAmbulances($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $data->brancheId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $data->communeId);
                $sub_array[] =  $data->numImmatriculation;
                $sub_array[] =  $data->chauffeur;
                $sub_array[] =  $data->gardeMalade;
                $sub_array[] =  $data->patient;
                $sub_array[] =  $data->agePatient;
                $sub_array[] =  CommonTrait::typeEvacuations($data->typeEvacuationId);
                $sub_array[] =  CommonTrait::modeEvacuations($data->modeEvacuationId);
                $sub_array[] =  $data->coutServiceAmbulance;
                $sub_array[] =  $data->coutDepense;
                $sub_array[] =  $data->dateDepart;
                $sub_array[] =  $data->dateRetour;


                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/data/ambulance/add/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/data/ambulance/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
    function export()
    {
        $uri = current_url(true);
        $brancheId = $uri->getSegment(5);

        if ($brancheId > 0) {
            $branche = CommonTrait::formatData(new BrancheModel(), $brancheId);
        } else {
            $branche = "Toutes les branches";
        }

        $fileName = str_replace(' ', '', $branche);
        $csv_file_name = "rapportExport/ambulance/ambulance_" . $fileName . ".csv";
        $file = fopen($csv_file_name, 'w');

        $arrays = [];
        $arrays[0] = ['', $this->formatText("Service ambulancier")];
        $arrays[1] = ['', $this->formatText($branche)];
        $arrays[2] = [];
        $arrays[3] = [
            '#',
            $this->formatText('Province'),
            $this->formatText('Branche'),
            $this->formatText('Num.Immatricule'),
            $this->formatText('Chauffeur'),
            $this->formatText('Staff'),
            $this->formatText('Garde malade'),
            $this->formatText('Tel'),
            $this->formatText("Date depart"),
            $this->formatText("Lieu d'évacuation "),
            $this->formatText("Type d'évacuation"),
            $this->formatText("Destinantion"),
            $this->formatText("Patient"),
            $this->formatText("sexe"),
            $this->formatText("Agent du patient"),
            $this->formatText("Diagnostic"),
            $this->formatText("Evacuation"),
            $this->formatText("Si payant (préciser le coût)"),
            $this->formatText("Dépenses liées à l’évacuation"),
            $this->formatText("Date de retour")
        ];


        if ($brancheId > 0) {
            $ambulances = $this->ambulanceModel->where('brancheId', $brancheId)->findAll();
        } else {
            $ambulances = $this->ambulanceModel->findAll();
        }

        $i = 1;
        foreach ($ambulances as $ambulance) {
            $sub_array = [];
            $sub_array[] = $i;
            $sub_array[] =  $this->formatText($ambulance->brancheId > 0 ?CommonTrait::formatData(new BrancheModel(), $ambulance->brancheId):"");
            $sub_array[] =  $this->formatText($ambulance->communeId > 0 ?CommonTrait::formatData(new CommuneModel(), $ambulance->communeId):"");
            $sub_array[] =  $this->formatText($ambulance->numImmatriculation);
            $sub_array[] =  $this->formatText($ambulance->chauffeur);
            $sub_array[] =  $this->formatText(self::formatMembre($ambulance->id));
            $sub_array[] =  $this->formatText($ambulance->gardeMalade);
            $sub_array[] =  $this->formatText($ambulance->telephone);
            $sub_array[] =  $this->formatText($ambulance->dateDepart);
            $sub_array[] =  $this->formatText($ambulance->lieuEvacuation);
            $sub_array[] =  $this->formatText($ambulance->typeEvacuationId > 0 ?CommonTrait::typeEvacuations($ambulance->typeEvacuationId):"");
            $sub_array[] =  $this->formatText($ambulance->destinationPatient);
            $sub_array[] =  $this->formatText($ambulance->patient);
            $sub_array[] =  $this->formatText($ambulance->sexe);
            $sub_array[] =  $this->formatText($ambulance->agePatient);
            $sub_array[] =  $this->formatText($ambulance->diagnostic);
            $sub_array[] =  $this->formatText( $ambulance->modeEvacuationId > 0 ?CommonTrait::modeEvacuations($ambulance->modeEvacuationId) :"");
            $sub_array[] =  $this->formatText($ambulance->coutServiceAmbulance);
            $sub_array[] =  $this->formatText($ambulance->coutDepense);
            $sub_array[] =  $this->formatText($ambulance->dateRetour);

            $arrays[] = $sub_array;
            $i++;
        }


        foreach ($arrays as $array) {
            fputcsv($file, $array, ";");
        }
        fclose($file);
        $btn = anchor($csv_file_name, "Exporter un <i class='fa fa-file-csv'></i>", ['class' => 'text-success', 'target' => '_blank']);

        $status = 0;
        if (fileExists($csv_file_name)) {
            $status = 1;
        }

        return $this->response->setJSON(['status' => $status, 'btnExport' => $btn]);
    }

    function formatText($string = "")
    {
        return UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
    }

    private static function formatMembre($id)
    {
        $membres = (new AmbulanceStaffModel())->where('ambulanceId', $id)->findAll();

        $mesMembres = "";
        foreach ($membres as $membre) {
            $mesMembres .= CommonTrait::formatData(new TypeStaff(), $membre->typeStaffId)." ";
            $mesMembres .= $membre->membre.", ";
        }

        return substr($mesMembres, 0,-1);
    }
}
