<?php

namespace Modules\data\Database\Migrations;

use CodeIgniter\Database\Migration;

class InfrastructureMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'zoneId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'collineId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'typeInfrastructureId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'acquisitionProprieteImmo' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'typeAttestationId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'coutEstime' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('dt_infrastructures');
    }

    public function down()
    {
        $this->forge->dropTable('dt_infrastructures');
    }
}
