<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold">Type d'attestation</h3>

            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$attestation->id]); ?>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <?= form_label("Description", 'descr'); ?>
                        <?php
                        $description = [
                            'type'  => 'text',
                            'name'  => 'description',
                            'id'    => 'description',
                            'value' => set_value('description', $attestation->description),
                            'placeholder' => "Description",
                            'class' => 'form-control',
                        ];

                        echo form_input($description);
                        ?>
                        <?= !empty(validation_show_error('description')) ? "<p class='text-danger'>" . validation_show_error('description') . "</p>" : "" ?>

                    </div>

                    
                    <div class="col-md-2 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


                <?php

                use CodeIgniter\View\Table;

                $table = new Table();

                $template = [
                    'table_open' => '<table class="table table-bordered" id="tables">',
                ];
                $table->setTemplate($template);
                $table->setHeading("#", "Description",  lang("Params.btn_option"));


                echo $table->generate();
                ?>
            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>