<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/ps/materiel", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }

                    echo validation_list_errors();
                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$materiel->id]); ?>
                <div class="row mb-3">

                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $materiel->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $materiel->communeId,
                    ];

                    echo form_input($cm);


                    ?>

                    <div class="col-md-3">
                        <?= form_label("Province <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $materiel->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Branche <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $materiel->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date enregistrement <font color='red'>*</font>"); ?>
                        <?php $date = $materiel->dateEnregistrement ? $materiel->dateEnregistrement : set_value('dateEnregistrement') ?>
                        <div class="input-group date" id="dateEnregistrement" data-target-input="nearest">
                            <?= form_input('dateEnregistrement', $date, "class='form-control datetimepicker-input', id='dateEnregistrement' placeholder='Date d\'enregistrement'") ?>
                            <div class="input-group-append" data-target="#dateEnregistrement" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateEnregistrement')) ? "<p class='text-danger'>" . validation_show_error('dateEnregistrement') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nombre de Mannequins enfants - Pièce"); ?>

                        <?php
                        $nbManuelPSEnfant = [
                            'type'  => 'text',
                            'name'  => 'nbManuelPSEnfant',
                            'id'    => 'nbManuelPSEnfant',
                            'value' => set_value('nbManuelPSEnfant', $materiel->nbManuelPSEnfant),
                            'placeholder' => "Nombre de Mannequins enfants - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbManuelPSEnfant);
                        ?>
                        <?= !empty(validation_show_error('nbManuelPSEnfant')) ? "<p class='text-danger'>" . validation_show_error('nbManuelPSEnfant') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Brancards - Pièce"); ?>

                        <?php
                        $nbBrancards = [
                            'type'  => 'text',
                            'name'  => 'nbBrancards',
                            'id'    => 'nbBrancards',
                            'value' => set_value('nbBrancards', $materiel->nbBrancards),
                            'placeholder' => "Brancards - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBrancards);
                        ?>
                        <?= !empty(validation_show_error('nbBrancards')) ? "<p class='text-danger'>" . validation_show_error('nbBrancards') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nombre de Mannequins enfants - Pièce"); ?>
                        <?php
                        $nbManequinEnfant = [
                            'type'  => 'text',
                            'name'  => 'nbManequinEnfant',
                            'id'    => 'nbManequinEnfant',
                            'value' => set_value('nbManequinEnfant', $materiel->nbManequinEnfant),
                            'placeholder' => "Nombre de Mannequins enfants - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbManequinEnfant);
                        ?>
                        <?= !empty(validation_show_error('nbManequinEnfant')) ? "<p class='text-danger'>" . validation_show_error('nbManequinEnfant') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nombre de Mannequins Adultes - Pièce"); ?>
                        <?php
                        $nbManequinEnAdulte = [
                            'type'  => 'text',
                            'name'  => 'nbManequinEnAdulte',
                            'id'    => 'nbManequinEnAdulte',
                            'value' => set_value('nbManequinEnAdulte', $materiel->nbManequinEnAdulte),
                            'placeholder' => "Nombre de Mannequins Adultes - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbManequinEnAdulte);
                        ?>
                        <?= !empty(validation_show_error('nbManequinEnAdulte')) ? "<p class='text-danger'>" . validation_show_error('nbManequinEnAdulte') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nombre d'Attèles - pièce"); ?>
                        <?php
                        $nbAttele = [
                            'type'  => 'text',
                            'name'  => 'nbAttele',
                            'id'    => 'nbAttele',
                            'value' => set_value('nbAttele', $materiel->nbAttele),
                            'placeholder' => "Nombre d'Attèles - pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbAttele);
                        ?>
                        <?= !empty(validation_show_error('nbAttele')) ? "<p class='text-danger'>" . validation_show_error('nbAttele') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Boîte à image - pièce"); ?>
                        <?php
                        $nbBoiteImage = [
                            'type'  => 'text',
                            'name'  => 'nbBoiteImage',
                            'id'    => 'nbBoiteImage',
                            'value' => set_value('nbBoiteImage', $materiel->nbBoiteImage),
                            'placeholder' => "Boîte à image - pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBoiteImage);
                        ?>
                        <?= !empty(validation_show_error('nbBoiteImage')) ? "<p class='text-danger'>" . validation_show_error('nbBoiteImage') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nombre de Couvertures"); ?>
                        <?php
                        $nbCouverture = [
                            'type'  => 'text',
                            'name'  => 'nbCouverture',
                            'id'    => 'nbCouverture',
                            'value' => set_value('nbCouverture', $materiel->nbCouverture),
                            'placeholder' => "Nombre de Couvertures",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbCouverture);
                        ?>
                        <?= !empty(validation_show_error('nbCouverture')) ? "<p class='text-danger'>" . validation_show_error('nbCouverture') . "</p>" : "" ?>
                    </div>
                    <div class="col-md-3">
                        <?= form_label("Nbre de manuels PS pour blessures de route"); ?>
                        <?php
                        $nbManuelPSBlessureRoute = [
                            'type'  => 'text',
                            'name'  => 'nbManuelPSBlessureRoute',
                            'id'    => 'nbManuelPSBlessureRoute',
                            'value' => set_value('nbManuelPSBlessureRoute', $materiel->nbManuelPSBlessureRoute),
                            'placeholder' => "Nbre de manuels PS pour blessures de route",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbManuelPSBlessureRoute);
                        ?>
                        <?= !empty(validation_show_error('nbManuelPSBlessureRoute')) ? "<p class='text-danger'>" . validation_show_error('nbManuelPSBlessureRoute') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nbre de manuels PS pour les premiers répondants"); ?>
                        <?php
                        $nbManuelPSBlessurePRepondant = [
                            'type'  => 'text',
                            'name'  => 'nbManuelPSBlessurePRepondant',
                            'id'    => 'nbManuelPSBlessurePRepondant',
                            'value' => set_value('nbManuelPSBlessurePRepondant', $materiel->nbManuelPSBlessurePRepondant),
                            'placeholder' => "Nbre de manuels PS pour les premiers répondants",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbManuelPSBlessurePRepondant);
                        ?>
                        <?= !empty(validation_show_error('nbManuelPSBlessurePRepondant')) ? "<p class='text-danger'>" . validation_show_error('nbManuelPSBlessurePRepondant') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nbre de mannequins bébé"); ?>
                        <?php
                        $nbManequinBebe = [
                            'type'  => 'text',
                            'name'  => 'nbManequinBebe',
                            'id'    => 'nbManequinBebe',
                            'value' => set_value('nbManequinBebe', $materiel->nbManequinBebe),
                            'placeholder' => "Nbre de mannequins bébé",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbManequinBebe);
                        ?>
                        <?= !empty(validation_show_error('nbManequinBebe')) ? "<p class='text-danger'>" . validation_show_error('nbManequinBebe') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nbre de kits PS"); ?>
                        <?php
                        $nbKitPS = [
                            'type'  => 'text',
                            'name'  => 'nbKitPS',
                            'id'    => 'nbKitPS',
                            'value' => set_value('nbKitPS', $materiel->nbKitPS),
                            'placeholder' => "Nbre de kits PS",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbKitPS);
                        ?>
                        <?= !empty(validation_show_error('nbKitPS')) ? "<p class='text-danger'>" . validation_show_error('nbKitPS') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nbre de ballons  insuflatteurs d'oxygène manuel"); ?>
                        <?php
                        $nbBallonInsuflatteurOxygene = [
                            'type'  => 'text',
                            'name'  => 'nbBallonInsuflatteurOxygene',
                            'id'    => 'nbBallonInsuflatteurOxygene',
                            'value' => set_value('nbBallonInsuflatteurOxygene', $materiel->nbBallonInsuflatteurOxygene),
                            'placeholder' => "Nbre de ballons  insuflatteurs d'oxygène manuel",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBallonInsuflatteurOxygene);
                        ?>
                        <?= !empty(validation_show_error('nbBallonInsuflatteurOxygene')) ? "<p class='text-danger'>" . validation_show_error('nbBallonInsuflatteurOxygene') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Défibrilateur automatique externes"); ?>
                        <?php
                        $nbDefibrillateurAutoExtern = [
                            'type'  => 'text',
                            'name'  => 'nbDefibrillateurAutoExtern',
                            'id'    => 'nbDefibrillateurAutoExtern',
                            'value' => set_value('nbDefibrillateurAutoExtern', $materiel->nbDefibrillateurAutoExtern),
                            'placeholder' => "Défibrilateur automatique externes",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbDefibrillateurAutoExtern);
                        ?>
                        <?= !empty(validation_show_error('nbDefibrillateurAutoExtern')) ? "<p class='text-danger'>" . validation_show_error('nbDefibrillateurAutoExtern') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Masques de poche"); ?>
                        <?php
                        $masquePoche = [
                            'type'  => 'text',
                            'name'  => 'masquePoche',
                            'id'    => 'masquePoche',
                            'value' => set_value('masquePoche', $materiel->masquePoche),
                            'placeholder' => "Masques de poche ",
                            'class' => 'form-control',
                        ];

                        echo form_input($masquePoche);
                        ?>
                        <?= !empty(validation_show_error('masquePoche')) ? "<p class='text-danger'>" . validation_show_error('masquePoche') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Existe -il Trousse de secours ?"); ?>
                        <?php
                        echo form_dropdown('existeTrousseSecour', $exTrouseSecours, set_value('existeTrousseSecour', $materiel->existeTrousseSecour), "class = 'form-control' id='existeTrousseSecour'");
                        ?>
                    </div>
                </div>

                <div class="row" id="divExiteTrousse">
                    <div class="col-md-3">
                        <?= form_label("Nombre de trousses de secours"); ?>
                        <?php
                        $nbTrousseSecour = [
                            'type'  => 'text',
                            'name'  => 'nbTrousseSecour',
                            'id'    => 'nbTrousseSecour',
                            'value' => set_value('nbTrousseSecour', $materiel->nbTrousseSecour),
                            'placeholder' => "Nombre de trousses de secours",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbTrousseSecour);
                        ?>
                        <?= !empty(validation_show_error('nbTrousseSecour')) ? "<p class='text-danger'>" . validation_show_error('nbTrousseSecour') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Gant propre ( à usage unique) - Paire"); ?>
                        <?php
                        $nbGrantProprePaire = [
                            'type'  => 'text',
                            'name'  => 'nbGrantProprePaire',
                            'id'    => 'nbGrantProprePaire',
                            'value' => set_value('nbGrantProprePaire', $materiel->nbGrantProprePaire),
                            'placeholder' => "Gant propre ( à usage unique) - Paire",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbGrantProprePaire);
                        ?>
                        <?= !empty(validation_show_error('nbGrantProprePaire')) ? "<p class='text-danger'>" . validation_show_error('nbGrantProprePaire') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Bétadine - Flacon"); ?>
                        <?php
                        $nbBetadineFlacon = [
                            'type'  => 'text',
                            'name'  => 'nbBetadineFlacon',
                            'id'    => 'nbBetadineFlacon',
                            'value' => set_value('nbBetadineFlacon', $materiel->nbBetadineFlacon),
                            'placeholder' => "Bétadine - Flacon",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBetadineFlacon);
                        ?>
                        <?= !empty(validation_show_error('nbBetadineFlacon')) ? "<p class='text-danger'>" . validation_show_error('nbBetadineFlacon') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Béttol - Flacon"); ?>
                        <?php
                        $nbBettolFlacon = [
                            'type'  => 'text',
                            'name'  => 'nbBettolFlacon',
                            'id'    => 'nbBettolFlacon',
                            'value' => set_value('nbBettolFlacon', $materiel->nbBettolFlacon),
                            'placeholder' => "Béttol - Flacon",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBettolFlacon);
                        ?>
                        <?= !empty(validation_show_error('nbBettolFlacon')) ? "<p class='text-danger'>" . validation_show_error('nbBettolFlacon') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Antalgique Pommade - tube"); ?>
                        <?php
                        $nbAntalgiquePommadeTube = [
                            'type'  => 'text',
                            'name'  => 'nbAntalgiquePommadeTube',
                            'id'    => 'nbAntalgiquePommadeTube',
                            'value' => set_value('nbAntalgiquePommadeTube', $materiel->nbAntalgiquePommadeTube),
                            'placeholder' => "Antalgique Pommade - tube",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbAntalgiquePommadeTube);
                        ?>
                        <?= !empty(validation_show_error('nbAntalgiquePommadeTube')) ? "<p class='text-danger'>" . validation_show_error('nbAntalgiquePommadeTube') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Antalgique Spray- tube"); ?>
                        <?php
                        $nbAntalgiqueSprayTube = [
                            'type'  => 'text',
                            'name'  => 'nbAntalgiqueSprayTube',
                            'id'    => 'nbAntalgiqueSprayTube',
                            'value' => set_value('nbAntalgiqueSprayTube', $materiel->nbAntalgiqueSprayTube),
                            'placeholder' => "Antalgique Spray- tube",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbAntalgiqueSprayTube);
                        ?>
                        <?= !empty(validation_show_error('nbAntalgiqueSprayTube')) ? "<p class='text-danger'>" . validation_show_error('nbAntalgiqueSprayTube') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Antalgique comprimé - CP"); ?>
                        <?php
                        $nbAntalgiqueComprimeCP = [
                            'type'  => 'text',
                            'name'  => 'nbAntalgiqueComprimeCP',
                            'id'    => 'nbAntalgiqueComprimeCP',
                            'value' => set_value('nbAntalgiqueComprimeCP', $materiel->nbAntalgiqueComprimeCP),
                            'placeholder' => "Antalgique comprimé - CP",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbAntalgiqueComprimeCP);
                        ?>
                        <?= !empty(validation_show_error('nbAntalgiqueComprimeCP')) ? "<p class='text-danger'>" . validation_show_error('nbAntalgiqueComprimeCP') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nombre de paires de ciseaux - pièce"); ?>
                        <?php
                        $nbPaireCiseauPiece = [
                            'type'  => 'text',
                            'name'  => 'nbPaireCiseauPiece',
                            'id'    => 'nbPaireCiseauPiece',
                            'value' => set_value('nbPaireCiseauPiece', $materiel->nbPaireCiseauPiece),
                            'placeholder' => "Nombre de paires de ciseaux - pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbPaireCiseauPiece);
                        ?>
                        <?= !empty(validation_show_error('nbPaireCiseauPiece')) ? "<p class='text-danger'>" . validation_show_error('nbPaireCiseauPiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Pinces Kocher - pièce"); ?>
                        <?php
                        $nbPinceKocherPiece = [
                            'type'  => 'text',
                            'name'  => 'nbPinceKocherPiece',
                            'id'    => 'nbPinceKocherPiece',
                            'value' => set_value('nbPinceKocherPiece', $materiel->nbPinceKocherPiece),
                            'placeholder' => "Pinces Kocher - pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbPinceKocherPiece);
                        ?>
                        <?= !empty(validation_show_error('nbPinceKocherPiece')) ? "<p class='text-danger'>" . validation_show_error('nbPinceKocherPiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Masque facial - pièce"); ?>
                        <?php
                        $nbMasqueFacialPiece = [
                            'type'  => 'text',
                            'name'  => 'nbMasqueFacialPiece',
                            'id'    => 'nbMasqueFacialPiece',
                            'value' => set_value('nbMasqueFacialPiece', $materiel->nbMasqueFacialPiece),
                            'placeholder' => "Masque facial - pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMasqueFacialPiece);
                        ?>
                        <?= !empty(validation_show_error('nbMasqueFacialPiece')) ? "<p class='text-danger'>" . validation_show_error('nbMasqueFacialPiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nombre de Serviette et essui-mains"); ?>
                        <?php
                        $nbServietteEssuiMain = [
                            'type'  => 'text',
                            'name'  => 'nbServietteEssuiMain',
                            'id'    => 'nbServietteEssuiMain',
                            'value' => set_value('nbServietteEssuiMain', $materiel->nbServietteEssuiMain),
                            'placeholder' => "Nombre de Serviette et essui-mains",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbServietteEssuiMain);
                        ?>
                        <?= !empty(validation_show_error('nbServietteEssuiMain')) ? "<p class='text-danger'>" . validation_show_error('nbServietteEssuiMain') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label(" Ouate - rouleau"); ?>
                        <?php
                        $ouateRouleau = [
                            'type'  => 'text',
                            'name'  => 'ouateRouleau',
                            'id'    => 'ouateRouleau',
                            'value' => set_value('ouateRouleau', $materiel->ouateRouleau),
                            'placeholder' => " Ouate - rouleau",
                            'class' => 'form-control',
                        ];

                        echo form_input($ouateRouleau);
                        ?>
                        <?= !empty(validation_show_error('ouateRouleau')) ? "<p class='text-danger'>" . validation_show_error('ouateRouleau') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Compresse stérile - pièces"); ?>
                        <?php
                        $nbCompresseSterilePiece = [
                            'type'  => 'text',
                            'name'  => 'nbCompresseSterilePiece',
                            'id'    => 'nbCompresseSterilePiece',
                            'value' => set_value('nbCompresseSterilePiece', $materiel->nbCompresseSterilePiece),
                            'placeholder' => "Compresse stérile - pièces",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbCompresseSterilePiece);
                        ?>
                        <?= !empty(validation_show_error('nbCompresseSterilePiece')) ? "<p class='text-danger'>" . validation_show_error('nbCompresseSterilePiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Echarpe/Drap triangulaire - pièce"); ?>
                        <?php
                        $echarpeDrapTriangulaire = [
                            'type'  => 'text',
                            'name'  => 'echarpeDrapTriangulaire',
                            'id'    => 'echarpeDrapTriangulaire',
                            'value' => set_value('echarpeDrapTriangulaire', $materiel->echarpeDrapTriangulaire),
                            'placeholder' => "Echarpe/Drap triangulaire - pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($echarpeDrapTriangulaire);
                        ?>
                        <?= !empty(validation_show_error('echarpeDrapTriangulaire')) ? "<p class='text-danger'>" . validation_show_error('echarpeDrapTriangulaire') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label(" Sparadrap perforé (Bande adhésive) - Rouleau"); ?>
                        <?php
                        $sparadrapPerforeRouleau = [
                            'type'  => 'text',
                            'name'  => 'sparadrapPerforeRouleau',
                            'id'    => 'sparadrapPerforeRouleau',
                            'value' => set_value('sparadrapPerforeRouleau', $materiel->sparadrapPerforeRouleau),
                            'placeholder' => " Sparadrap perforé (Bande adhésive) - Rouleau",
                            'class' => 'form-control',
                        ];

                        echo form_input($sparadrapPerforeRouleau);
                        ?>
                        <?= !empty(validation_show_error('sparadrapPerforeRouleau')) ? "<p class='text-danger'>" . validation_show_error('sparadrapPerforeRouleau') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Sparadrap étanche - Pièce"); ?>
                        <?php
                        $sparadrapEtanchePiece = [
                            'type'  => 'text',
                            'name'  => 'sparadrapEtanchePiece',
                            'id'    => 'sparadrapEtanchePiece',
                            'value' => set_value('sparadrapEtanchePiece', $materiel->sparadrapEtanchePiece),
                            'placeholder' => "Sparadrap étanche - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($sparadrapEtanchePiece);
                        ?>
                        <?= !empty(validation_show_error('sparadrapEtanchePiece')) ? "<p class='text-danger'>" . validation_show_error('sparadrapEtanchePiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Bande Elastique (Velpeau) - Pièce"); ?>
                        <?php
                        $bandeElastiquePiece = [
                            'type'  => 'text',
                            'name'  => 'bandeElastiquePiece',
                            'id'    => 'bandeElastiquePiece',
                            'value' => set_value('bandeElastiquePiece', $materiel->bandeElastiquePiece),
                            'placeholder' => "Bande Elastique (Velpeau) - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($bandeElastiquePiece);
                        ?>
                        <?= !empty(validation_show_error('bandeElastiquePiece')) ? "<p class='text-danger'>" . validation_show_error('bandeElastiquePiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Ambu buccal enfant - Pièce"); ?>
                        <?php
                        $ambuBuccalEnfantPiece = [
                            'type'  => 'text',
                            'name'  => 'ambuBuccalEnfantPiece',
                            'id'    => 'ambuBuccalEnfantPiece',
                            'value' => set_value('ambuBuccalEnfantPiece', $materiel->ambuBuccalEnfantPiece),
                            'placeholder' => "Ambu buccal enfant - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($ambuBuccalEnfantPiece);
                        ?>
                        <?= !empty(validation_show_error('ambuBuccalEnfantPiece')) ? "<p class='text-danger'>" . validation_show_error('ambuBuccalEnfantPiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Ambu buccal adulte - Pièce"); ?>
                        <?php
                        $ambuBuccalAdultePiece = [
                            'type'  => 'text',
                            'name'  => 'ambuBuccalAdultePiece',
                            'id'    => 'ambuBuccalAdultePiece',
                            'value' => set_value('ambuBuccalAdultePiece', $materiel->ambuBuccalAdultePiece),
                            'placeholder' => "Ambu buccal adulte - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($ambuBuccalAdultePiece);
                        ?>
                        <?= !empty(validation_show_error('ambuBuccalAdultePiece')) ? "<p class='text-danger'>" . validation_show_error('ambuBuccalAdultePiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Ambu buccal nourrisson - Pièce"); ?>
                        <?php
                        $ambuBuccalNourrissonPiece = [
                            'type'  => 'text',
                            'name'  => 'ambuBuccalNourrissonPiece',
                            'id'    => 'ambuBuccalNourrissonPiece',
                            'value' => set_value('ambuBuccalNourrissonPiece', $materiel->ambuBuccalNourrissonPiece),
                            'placeholder' => "Ambu buccal nourrisson - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($ambuBuccalNourrissonPiece);
                        ?>
                        <?= !empty(validation_show_error('ambuBuccalNourrissonPiece')) ? "<p class='text-danger'>" . validation_show_error('ambuBuccalNourrissonPiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nombre - Savons ( pièce)"); ?>
                        <?php
                        $nbSavonPiece = [
                            'type'  => 'text',
                            'name'  => 'nbSavonPiece',
                            'id'    => 'nbSavonPiece',
                            'value' => set_value('nbSavonPiece', $materiel->nbSavonPiece),
                            'placeholder' => "Nombre - Savons ( pièce)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbSavonPiece);
                        ?>
                        <?= !empty(validation_show_error('nbSavonPiece')) ? "<p class='text-danger'>" . validation_show_error('nbSavonPiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Thermomètre - pièce"); ?>
                        <?php
                        $nbThermometrePiece = [
                            'type'  => 'text',
                            'name'  => 'nbThermometrePiece',
                            'id'    => 'nbThermometrePiece',
                            'value' => set_value('nbThermometrePiece', $materiel->nbThermometrePiece),
                            'placeholder' => "Thermomètre - pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbThermometrePiece);
                        ?>
                        <?= !empty(validation_show_error('nbThermometrePiece')) ? "<p class='text-danger'>" . validation_show_error('nbThermometrePiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Thermos - Pièce"); ?>
                        <?php
                        $nbThermosPiece = [
                            'type'  => 'text',
                            'name'  => 'nbThermosPiece',
                            'id'    => 'nbThermosPiece',
                            'value' => set_value('nbThermosPiece', $materiel->nbThermosPiece),
                            'placeholder' => "Thermos - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbThermosPiece);
                        ?>
                        <?= !empty(validation_show_error('nbThermosPiece')) ? "<p class='text-danger'>" . validation_show_error('nbThermosPiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("SRO ( Sel de Réhydratation Orale) - Pièce"); ?>
                        <?php
                        $nbSROPiece = [
                            'type'  => 'text',
                            'name'  => 'nbSROPiece',
                            'id'    => 'nbSROPiece',
                            'value' => set_value('nbSROPiece', $materiel->nbSROPiece),
                            'placeholder' => "SRO ( Sel de Réhydratation Orale) - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbSROPiece);
                        ?>
                        <?= !empty(validation_show_error('nbSROPiece')) ? "<p class='text-danger'>" . validation_show_error('nbSROPiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Picette ( Solution de Dettol) - Pièce"); ?>
                        <?php
                        $picettePiece = [
                            'type'  => 'text',
                            'name'  => 'picettePiece',
                            'id'    => 'picettePiece',
                            'value' => set_value('picettePiece', $materiel->picettePiece),
                            'placeholder' => "Picette ( Solution de Dettol) - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($picettePiece);
                        ?>
                        <?= !empty(validation_show_error('picettePiece')) ? "<p class='text-danger'>" . validation_show_error('picettePiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Lame de Rasoir - Pièce"); ?>
                        <?php
                        $lameRasoirPiece = [
                            'type'  => 'text',
                            'name'  => 'lameRasoirPiece',
                            'id'    => 'lameRasoirPiece',
                            'value' => set_value('lameRasoirPiece', $materiel->lameRasoirPiece),
                            'placeholder' => "Lame de Rasoir - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($lameRasoirPiece);
                        ?>
                        <?= !empty(validation_show_error('lameRasoirPiece')) ? "<p class='text-danger'>" . validation_show_error('lameRasoirPiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Sac poubelle - Pièce"); ?>
                        <?php
                        $sacPoubellePiece = [
                            'type'  => 'text',
                            'name'  => 'sacPoubellePiece',
                            'id'    => 'sacPoubellePiece',
                            'value' => set_value('sacPoubellePiece', $materiel->sacPoubellePiece),
                            'placeholder' => "Sac poubelle - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($sacPoubellePiece);
                        ?>
                        <?= !empty(validation_show_error('sacPoubellePiece')) ? "<p class='text-danger'>" . validation_show_error('sacPoubellePiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Carnet ( Fiche de gestion de la trousse) - Pièce"); ?>
                        <?php
                        $carnetTroussePiece = [
                            'type'  => 'text',
                            'name'  => 'carnetTroussePiece',
                            'id'    => 'carnetTroussePiece',
                            'value' => set_value('carnetTroussePiece', $materiel->carnetTroussePiece),
                            'placeholder' => "Carnet ( Fiche de gestion de la trousse) - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($carnetTroussePiece);
                        ?>
                        <?= !empty(validation_show_error('carnetTroussePiece')) ? "<p class='text-danger'>" . validation_show_error('carnetTroussePiece') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Stylo - Pièce"); ?>
                        <?php
                        $styloPiece = [
                            'type'  => 'text',
                            'name'  => 'styloPiece',
                            'id'    => 'styloPiece',
                            'value' => set_value('styloPiece', $materiel->styloPiece),
                            'placeholder' => "Stylo - Pièce",
                            'class' => 'form-control',
                        ];

                        echo form_input($styloPiece);
                        ?>
                        <?= !empty(validation_show_error('styloPiece')) ? "<p class='text-danger'>" . validation_show_error('styloPiece') . "</p>" : "" ?>
                    </div>

                </div>

                <div class="row">
                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>