!/**
 * Highstock JS v11.4.0 (2024-03-04)
 *
 * Advanced Highcharts Stock tools
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/stock-tools",["highcharts","highcharts/modules/stock"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function e(t,i,e,n){t.hasOwnProperty(i)||(t[i]=n.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:t[i]}})))}e(i,"Core/Chart/ChartNavigationComposition.js",[],function(){var t,i,e;return(i=t||(t={})).compose=function(t){return t.navigation||(t.navigation=new e(t)),t},e=function(){function t(t){this.updates=[],this.chart=t}return t.prototype.addUpdate=function(t){this.chart.navigation.updates.push(t)},t.prototype.update=function(t,i){var e=this;this.updates.forEach(function(n){n.call(e.chart,t,i)})},t}(),i.Additions=e,t}),e(i,"Extensions/Annotations/NavigationBindingsDefaults.js",[i["Extensions/Annotations/NavigationBindingsUtilities.js"],i["Core/Utilities.js"]],function(t,i){var e=t.getAssignedAxis,n=i.isNumber,s=i.merge;return{lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",ellipse:"Ellipse",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(t){var i,n=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t),o=n&&e(n.xAxis),a=n&&e(n.yAxis),r=this.chart.options.navigation;if(o&&a)return this.chart.addAnnotation(s({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:o.value,y:a.value,xAxis:o.axis.index,yAxis:a.axis.index},r:5}]},r.annotationsOptions,r.bindings.circleAnnotation.annotationsOptions))},steps:[function(t,i){var e,s=i.options.shapes,o=s&&s[0]&&s[0].point||{};if(n(o.xAxis)&&n(o.yAxis)){var a=this.chart.inverted,r=this.chart.xAxis[o.xAxis].toPixels(o.x),l=this.chart.yAxis[o.yAxis].toPixels(o.y);e=Math.max(Math.sqrt(Math.pow(a?l-t.chartX:r-t.chartX,2)+Math.pow(a?r-t.chartY:l-t.chartY,2)),5)}i.update({shapes:[{r:e}]})}]},ellipseAnnotation:{className:"highcharts-ellipse-annotation",start:function(t){var i,n=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t),o=n&&e(n.xAxis),a=n&&e(n.yAxis),r=this.chart.options.navigation;if(o&&a)return this.chart.addAnnotation(s({langKey:"ellipse",type:"basicAnnotation",shapes:[{type:"ellipse",xAxis:o.axis.index,yAxis:a.axis.index,points:[{x:o.value,y:a.value},{x:o.value,y:a.value}],ry:1}]},r.annotationsOptions,r.bindings.ellipseAnnotation.annotationOptions))},steps:[function(t,i){var e=i.shapes[0],n=e.getAbsolutePosition(e.points[1]);e.translatePoint(t.chartX-n.x,t.chartY-n.y,1),e.redraw(!1)},function(t,i){var e=i.shapes[0],n=e.getAbsolutePosition(e.points[0]),s=e.getAbsolutePosition(e.points[1]),o=e.getDistanceFromLine(n,s,t.chartX,t.chartY),a=e.getYAxis(),r=Math.abs(a.toValue(0)-a.toValue(o));e.setYRadius(r),e.redraw(!1)}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(t){var i,n=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t),o=n&&e(n.xAxis),a=n&&e(n.yAxis);if(o&&a){var r=o.value,l=a.value,c=o.axis.index,h=a.axis.index,p=this.chart.options.navigation;return this.chart.addAnnotation(s({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:c,yAxis:h,x:r,y:l},{xAxis:c,yAxis:h,x:r,y:l},{xAxis:c,yAxis:h,x:r,y:l},{xAxis:c,yAxis:h,x:r,y:l},{command:"Z"}]}]},p.annotationsOptions,p.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(t,i){var n,s=i.options.shapes,o=s&&s[0]&&s[0].points||[],a=null===(n=this.chart.pointer)||void 0===n?void 0:n.getCoordinates(t),r=a&&e(a.xAxis),l=a&&e(a.yAxis);if(r&&l){var c=r.value,h=l.value;o[1].x=c,o[2].x=c,o[2].y=h,o[3].y=h,i.update({shapes:[{points:o}]})}}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(t){var i,n=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t),o=n&&e(n.xAxis),a=n&&e(n.yAxis),r=this.chart.options.navigation;if(o&&a)return this.chart.addAnnotation(s({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}",overflow:"none",crop:!0},labels:[{point:{xAxis:o.axis.index,yAxis:a.axis.index,x:o.value,y:a.value}}]},r.annotationsOptions,r.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}}}),e(i,"Extensions/Annotations/NavigationBindings.js",[i["Core/Chart/ChartNavigationComposition.js"],i["Core/Defaults.js"],i["Core/Templating.js"],i["Core/Globals.js"],i["Extensions/Annotations/NavigationBindingsDefaults.js"],i["Extensions/Annotations/NavigationBindingsUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,n,s,o,a){var r=i.setOptions,l=e.format,c=n.composed,h=n.doc,p=n.win,d=o.getAssignedAxis,u=o.getFieldType,g=a.addEvent,v=a.attr,y=a.defined,f=a.fireEvent,m=a.isArray,x=a.isFunction,b=a.isNumber,k=a.isObject,A=a.merge,C=a.objectEach,w=a.pick,O=a.pushUnique;function T(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()}function S(){this.navigationBindings&&this.navigationBindings.destroy()}function N(){var t=this.options;t&&t.navigation&&t.navigation.bindings&&(this.navigationBindings=new I(this,t.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())}function L(){var t=this.navigationBindings,i="highcharts-disabled-btn";if(this&&t){var e=!1;if(this.series.forEach(function(t){!t.options.isInternal&&t.visible&&(e=!0)}),this.navigationBindings&&this.navigationBindings.container&&this.navigationBindings.container[0]){var n=this.navigationBindings.container[0];C(t.boundClassNames,function(t,s){var o=n.querySelectorAll("."+s);if(o)for(var a=0;a<o.length;a++){var r=o[a],l=r.className;"normal"===t.noDataState?-1!==l.indexOf(i)&&r.classList.remove(i):e?-1!==l.indexOf(i)&&r.classList.remove(i):-1===l.indexOf(i)&&(r.className+=" "+i)}})}}}function B(){this.deselectAnnotation()}function E(){this.selectedButtonElement=null}function W(t){var i,e,n=t.prototype.defaultOptions.events&&t.prototype.defaultOptions.events.click;function s(t){var i=this,e=i.chart.navigationBindings,s=e.activeAnnotation;n&&n.call(i,t),s!==i?(e.deselectAnnotation(),e.activeAnnotation=i,i.setControlPointsVisibility(!0),f(e,"showPopup",{annotation:i,formType:"annotation-toolbar",options:e.annotationToFields(i),onSubmit:function(t){if("remove"===t.actionType)e.activeAnnotation=!1,e.chart.removeAnnotation(i);else{var n={};e.fieldsToOptions(t.fields,n),e.deselectAnnotation();var s=n.typeOptions;"measure"===i.options.type&&(s.crosshairY.enabled=0!==s.crosshairY.strokeWidth,s.crosshairX.enabled=0!==s.crosshairX.strokeWidth),i.update(n)}}})):f(e,"closePopup"),t.activeAnnotation=!0}A(!0,t.prototype.defaultOptions.events,{click:s,touchstart:function(t){i=t.touches[0].clientX,e=t.touches[0].clientY},touchend:function(t){i&&Math.sqrt(Math.pow(i-t.changedTouches[0].clientX,2)+Math.pow(e-t.changedTouches[0].clientY,2))>=4||s.call(this,t)}})}var I=function(){function i(t,i){this.boundClassNames=void 0,this.chart=t,this.options=i,this.eventsToUnbind=[],this.container=this.chart.container.getElementsByClassName(this.options.bindingsClassName||""),this.container.length||(this.container=h.getElementsByClassName(this.options.bindingsClassName||""))}return i.compose=function(t,e){O(c,"NavigationBindings")&&(g(t,"remove",T),W(t),C(t.types,function(t){W(t)}),g(e,"destroy",S),g(e,"load",N),g(e,"render",L),g(i,"closePopup",B),g(i,"deselectButton",E),r(s))},i.prototype.getCoords=function(t){var i,e=null===(i=this.chart.pointer)||void 0===i?void 0:i.getCoordinates(t);return[e&&d(e.xAxis),e&&d(e.yAxis)]},i.prototype.initEvents=function(){var t=this,i=t.chart,e=t.container,s=t.options;t.boundClassNames={},C(s.bindings||{},function(i){t.boundClassNames[i.className]=i}),[].forEach.call(e,function(i){t.eventsToUnbind.push(g(i,"click",function(e){var n=t.getButtonEvents(i,e);n&&!n.button.classList.contains("highcharts-disabled-btn")&&t.bindingsButtonClick(n.button,n.events,e)}))}),C(s.events||{},function(i,e){x(i)&&t.eventsToUnbind.push(g(t,e,i,{passive:!1}))}),t.eventsToUnbind.push(g(i.container,"click",function(e){!i.cancelClick&&i.isInsidePlot(e.chartX-i.plotLeft,e.chartY-i.plotTop,{visiblePlotOnly:!0})&&t.bindingsChartClick(this,e)})),t.eventsToUnbind.push(g(i.container,n.isTouchDevice?"touchmove":"mousemove",function(i){t.bindingsContainerMouseMove(this,i)},n.isTouchDevice?{passive:!1}:void 0))},i.prototype.initUpdate=function(){var i=this;t.compose(this.chart).navigation.addUpdate(function(t){i.update(t)})},i.prototype.bindingsButtonClick=function(t,i,e){var n=this.chart,s=n.renderer.boxWrapper,o=!0;this.selectedButtonElement&&(this.selectedButtonElement.classList===t.classList&&(o=!1),f(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&n.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1)),o?(this.selectedButton=i,this.selectedButtonElement=t,f(this,"selectButton",{button:t}),i.init&&i.init.call(this,t,e),(i.start||i.steps)&&n.renderer.boxWrapper.addClass("highcharts-draw-mode")):(n.stockTools&&n.stockTools.toggleButtonActiveClass(t),s.removeClass("highcharts-draw-mode"),this.nextEvent=!1,this.mouseMoveEvent=!1,this.selectedButton=null)},i.prototype.bindingsChartClick=function(t,i){t=this.chart;var e=this.activeAnnotation,n=this.selectedButton,s=t.renderer.boxWrapper;e&&(e.cancelClick||i.activeAnnotation||!i.target.parentNode||function(t,i){var e=p.Element.prototype,n=e.matches||e.msMatchesSelector||e.webkitMatchesSelector,s=null;if(e.closest)s=e.closest.call(t,i);else do{if(n.call(t,i))return t;t=t.parentElement||t.parentNode}while(null!==t&&1===t.nodeType);return s}(i.target,".highcharts-popup")?e.cancelClick&&setTimeout(function(){e.cancelClick=!1},0):f(this,"closePopup")),n&&n.start&&(this.nextEvent?(this.nextEvent(i,this.currentUserDetails),this.steps&&(this.stepIndex++,n.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=n.steps[this.stepIndex]:(f(this,"deselectButton",{button:this.selectedButtonElement}),s.removeClass("highcharts-draw-mode"),n.end&&n.end.call(this,i,this.currentUserDetails),this.nextEvent=!1,this.mouseMoveEvent=!1,this.selectedButton=null))):(this.currentUserDetails=n.start.call(this,i),this.currentUserDetails&&n.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=n.steps[this.stepIndex]):(f(this,"deselectButton",{button:this.selectedButtonElement}),s.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,n.end&&n.end.call(this,i,this.currentUserDetails))))},i.prototype.bindingsContainerMouseMove=function(t,i){this.mouseMoveEvent&&this.mouseMoveEvent(i,this.currentUserDetails)},i.prototype.fieldsToOptions=function(t,i){return C(t,function(t,e){var n=parseFloat(t),s=e.split("."),o=s.length-1;if(!b(n)||t.match(/px|em/g)||e.match(/format/g)||(t=n),"undefined"!==t){var a=i;s.forEach(function(i,e){if("__proto__"!==i&&"constructor"!==i){var n=w(s[e+1],"");o===e?a[i]=t:(a[i]||(a[i]=n.match(/\d/g)?[]:{}),a=a[i])}})}}),i},i.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},i.prototype.annotationToFields=function(t){var e=t.options,n=i.annotationsEditable,s=n.nestedOptions,o=w(e.type,e.shapes&&e.shapes[0]&&e.shapes[0].type,e.labels&&e.labels[0]&&e.labels[0].type,"label"),a=i.annotationsNonEditable[e.langKey]||[],r={langKey:e.langKey,type:o};function c(i,e,n,o,r){var h;n&&y(i)&&-1===a.indexOf(e)&&((n.indexOf&&n.indexOf(e))>=0||n[e]||!0===n)&&(m(i)?(o[e]=[],i.forEach(function(t,i){k(t)?(o[e][i]={},C(t,function(t,n){c(t,n,s[e],o[e][i],e)})):c(t,0,s[e],o[e],e)})):k(i)?(h={},m(o)?(o.push(h),h[e]={},h=h[e]):o[e]=h,C(i,function(t,i){c(t,i,0===e?n:s[e],h,e)})):"format"===e?o[e]=[l(i,t.labels[0].points[0]).toString(),"text"]:m(o)?o.push([i,u(r,i)]):o[e]=[i,u(e,i)])}return C(e,function(t,i){"typeOptions"===i?(r[i]={},C(e[i],function(t,e){c(t,e,s,r[i],e)})):c(t,i,n[o],r,i)}),r},i.prototype.getClickedClassNames=function(t,i){for(var e,n=i.target,s=[];n&&n.tagName&&((e=v(n,"class"))&&(s=s.concat(e.split(" ").map(function(t){return[t,n]}))),(n=n.parentNode)!==t););return s},i.prototype.getButtonEvents=function(t,i){var e,n=this;return this.getClickedClassNames(t,i).forEach(function(t){n.boundClassNames[t[0]]&&!e&&(e={events:n.boundClassNames[t[0]],button:t[1]})}),e},i.prototype.update=function(t){this.options=A(!0,this.options,t),this.removeEvents(),this.initEvents()},i.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(t){return t()})},i.prototype.destroy=function(){this.removeEvents()},i.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],ellipse:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},i.annotationsNonEditable={rectangle:["crosshairX","crosshairY","labelOptions"],ellipse:["labelOptions"],circle:["labelOptions"]},i}();return I}),e(i,"Stock/StockTools/StockToolsUtilities.js",[i["Core/Defaults.js"],i["Extensions/Annotations/NavigationBindingsUtilities.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,n){var s=t.getOptions,o=i.getAssignedAxis,a=i.getFieldType,r=n.defined,l=n.fireEvent,c=n.isNumber,h=n.uniqueKey,p=["apo","ad","aroon","aroonoscillator","atr","ao","cci","chaikin","cmf","cmo","disparityindex","dmi","dpo","linearRegressionAngle","linearRegressionIntercept","linearRegressionSlope","klinger","macd","mfi","momentum","natr","obv","ppo","roc","rsi","slowstochastic","stochastic","trix","williamsr"],d=["ad","cmf","klinger","mfi","obv","vbp","vwap"];function u(t,i){var e,n,s,a,r=null===(e=i.pointer)||void 0===e?void 0:e.getCoordinates(t),l=Number.MAX_VALUE;if(i.navigationBindings&&r&&(n=o(r.xAxis),s=o(r.yAxis)),n&&s){var c=n.value,h=s.value;if(s.axis.series.forEach(function(i){if(i.points){var e=i.searchPoint(t,!0);e&&l>Math.abs(e.x-c)&&(l=Math.abs(e.x-c),a=e)}}),a&&a.x&&a.y)return{x:a.x,y:a.y,below:h<a.y,series:a.series,xAxis:a.series.xAxis.index||0,yAxis:a.series.yAxis.index||0}}}return{indicatorsWithAxes:p,indicatorsWithVolume:d,addFlagFromForm:function(t){return function(i){var e=this,n=e.chart,s=n.stockTools,o=u(i,n);if(o){var r={x:o.x,y:o.y},c={type:"flags",onSeries:o.series.id,shape:t,data:[r],xAxis:o.xAxis,yAxis:o.yAxis,point:{events:{click:function(){var t=this,i=t.options;l(e,"showPopup",{point:t,formType:"annotation-toolbar",options:{langKey:"flags",type:"flags",title:[i.title,a("title",i.title)],name:[i.name,a("name",i.name)]},onSubmit:function(i){"remove"===i.actionType?t.remove():t.update(e.fieldsToOptions(i.fields,{}))}})}}}};s&&s.guiEnabled||n.addSeries(c),l(e,"showPopup",{formType:"flag",options:{langKey:"flags",type:"flags",title:["A",a("label","A")],name:["Flag A",a("label","Flag A")]},onSubmit:function(t){e.fieldsToOptions(t.fields,c.data[0]),n.addSeries(c)}})}}},attractToPoint:u,getAssignedAxis:o,isNotNavigatorYAxis:function(t){return"highcharts-navigator-yaxis"!==t.userOptions.className},isPriceIndicatorEnabled:function(t){return t.some(function(t){return t.lastVisiblePrice||t.lastPrice})},manageIndicators:function(t){var i,n,o,a,c=this.chart,u={linkedTo:t.linkedTo,type:t.type};if("edit"===t.actionType)this.fieldsToOptions(t.fields,u),(a=c.get(t.seriesId))&&a.update(u,!1);else if("remove"===t.actionType){if((a=c.get(t.seriesId))&&(i=a.yAxis,a.linkedSeries&&a.linkedSeries.forEach(function(t){t.remove(!1)}),a.remove(!1),p.indexOf(a.type)>=0)){var g={height:i.options.height,top:i.options.top};i.remove(!1),this.resizeYAxes(g)}}else u.id=h(),this.fieldsToOptions(t.fields,u),n=c.get(u.linkedTo),o=s().plotOptions,void 0!==n&&n instanceof e&&"sum"===n.getDGApproximation()&&!r(o&&o[u.type]&&o.dataGrouping&&o.dataGrouping.approximation)&&(u.dataGrouping={approximation:"sum"}),p.indexOf(t.type)>=0?(i=c.addAxis({id:h(),offset:0,opposite:!0,title:{text:""},tickPixelInterval:40,showLastLabel:!1,labels:{align:"left",y:-2}},!1,!1),u.yAxis=i.options.id,this.resizeYAxes()):u.yAxis=c.get(t.linkedTo).options.yAxis,d.indexOf(t.type)>=0&&(u.params.volumeSeriesID=c.series.filter(function(t){return"column"===t.options.type})[0].options.id),c.addSeries(u,!1);l(this,"deselectButton",{button:this.selectedButtonElement}),c.redraw()},updateHeight:function(t,i){var e=i.options.typeOptions,n=c(e.yAxis)&&this.chart.yAxis[e.yAxis];n&&e.points&&i.update({typeOptions:{height:n.toValue(t[n.horiz?"chartX":"chartY"])-(e.points[1].y||0)}})},updateNthPoint:function(t){return function(i,e){var n=e.options.typeOptions,s=c(n.xAxis)&&this.chart.xAxis[n.xAxis],o=c(n.yAxis)&&this.chart.yAxis[n.yAxis];s&&o&&(n.points.forEach(function(e,n){n>=t&&(e.x=s.toValue(i[s.horiz?"chartX":"chartY"]),e.y=o.toValue(i[o.horiz?"chartX":"chartY"]))}),e.update({typeOptions:{points:n.points}}))}},updateRectSize:function(t,i){var e=i.chart,n=i.options.typeOptions,s=c(n.xAxis)&&e.xAxis[n.xAxis],o=c(n.yAxis)&&e.yAxis[n.yAxis];if(s&&o){var a=s.toValue(t[s.horiz?"chartX":"chartY"]),r=o.toValue(t[o.horiz?"chartX":"chartY"]),l=a-n.point.x,h=n.point.y-r;i.update({typeOptions:{background:{width:e.inverted?h:l,height:e.inverted?l:h}}})}}}}),e(i,"Stock/StockTools/StockToolsBindings.js",[i["Core/Globals.js"],i["Stock/StockTools/StockToolsUtilities.js"],i["Core/Utilities.js"]],function(t,i,e){var n=i.addFlagFromForm,s=i.attractToPoint,o=i.isNotNavigatorYAxis,a=i.isPriceIndicatorEnabled,r=i.manageIndicators,l=i.updateHeight,c=i.updateNthPoint,h=i.updateRectSize,p=e.fireEvent,d=e.merge;return{segment:{className:"highcharts-segment",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=this.chart.options.navigation,o=d({langKey:"segment",type:"crookedLine",typeOptions:{xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value,y:n.value},{x:e.value,y:n.value}]}},s.annotationsOptions,s.bindings.segment.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},arrowSegment:{className:"highcharts-arrow-segment",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=this.chart.options.navigation,o=d({langKey:"arrowSegment",type:"crookedLine",typeOptions:{line:{markerEnd:"arrow"},xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value,y:n.value},{x:e.value,y:n.value}]}},s.annotationsOptions,s.bindings.arrowSegment.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},ray:{className:"highcharts-ray",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=this.chart.options.navigation,o=d({langKey:"ray",type:"infinityLine",typeOptions:{type:"ray",xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value,y:n.value},{x:e.value,y:n.value}]}},s.annotationsOptions,s.bindings.ray.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},arrowRay:{className:"highcharts-arrow-ray",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=this.chart.options.navigation,o=d({langKey:"arrowRay",type:"infinityLine",typeOptions:{type:"ray",line:{markerEnd:"arrow"},xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value,y:n.value},{x:e.value,y:n.value}]}},s.annotationsOptions,s.bindings.arrowRay.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},infinityLine:{className:"highcharts-infinity-line",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=this.chart.options.navigation,o=d({langKey:"infinityLine",type:"infinityLine",typeOptions:{type:"line",xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value,y:n.value},{x:e.value,y:n.value}]}},s.annotationsOptions,s.bindings.infinityLine.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},arrowInfinityLine:{className:"highcharts-arrow-infinity-line",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=this.chart.options.navigation,o=d({langKey:"arrowInfinityLine",type:"infinityLine",typeOptions:{type:"line",line:{markerEnd:"arrow"},xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value,y:n.value},{x:e.value,y:n.value}]}},s.annotationsOptions,s.bindings.arrowInfinityLine.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[c(1)]},horizontalLine:{className:"highcharts-horizontal-line",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=this.chart.options.navigation,o=d({langKey:"horizontalLine",type:"infinityLine",draggable:"y",typeOptions:{type:"horizontalLine",xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value,y:n.value}]}},s.annotationsOptions,s.bindings.horizontalLine.annotationsOptions);this.chart.addAnnotation(o)}}},verticalLine:{className:"highcharts-vertical-line",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=this.chart.options.navigation,o=d({langKey:"verticalLine",type:"infinityLine",draggable:"x",typeOptions:{type:"verticalLine",xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value,y:n.value}]}},s.annotationsOptions,s.bindings.verticalLine.annotationsOptions);this.chart.addAnnotation(o)}}},crooked3:{className:"highcharts-crooked3",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"crooked3",type:"crookedLine",typeOptions:{xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:s,y:o},{x:s,y:o},{x:s,y:o}]}},a.annotationsOptions,a.bindings.crooked3.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2)]},crooked5:{className:"highcharts-crooked5",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"crooked5",type:"crookedLine",typeOptions:{xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:s,y:o},{x:s,y:o},{x:s,y:o},{x:s,y:o},{x:s,y:o}]}},a.annotationsOptions,a.bindings.crooked5.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2),c(3),c(4)]},elliott3:{className:"highcharts-elliott3",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"elliott3",type:"elliottWave",typeOptions:{xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:s,y:o},{x:s,y:o},{x:s,y:o},{x:s,y:o}]},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.elliott3.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2),c(3)]},elliott5:{className:"highcharts-elliott5",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"elliott5",type:"elliottWave",typeOptions:{xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:s,y:o},{x:s,y:o},{x:s,y:o},{x:s,y:o},{x:s,y:o},{x:s,y:o}]},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.elliott5.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2),c(3),c(4),c(5)]},measureX:{className:"highcharts-measure-x",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"measure",type:"measure",typeOptions:{selectType:"x",xAxis:e.axis.index,yAxis:n.axis.index,point:{x:s,y:o},crosshairX:{strokeWidth:1,stroke:"#000000"},crosshairY:{enabled:!1,strokeWidth:0,stroke:"#000000"},background:{width:0,height:0,strokeWidth:0,stroke:"#ffffff"}},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.measureX.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[h]},measureY:{className:"highcharts-measure-y",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"measure",type:"measure",typeOptions:{selectType:"y",xAxis:e.axis.index,yAxis:n.axis.index,point:{x:s,y:o},crosshairX:{enabled:!1,strokeWidth:0,stroke:"#000000"},crosshairY:{strokeWidth:1,stroke:"#000000"},background:{width:0,height:0,strokeWidth:0,stroke:"#ffffff"}},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.measureY.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[h]},measureXY:{className:"highcharts-measure-xy",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"measure",type:"measure",typeOptions:{selectType:"xy",xAxis:e.axis.index,yAxis:n.axis.index,point:{x:s,y:o},background:{width:0,height:0,strokeWidth:10},crosshairX:{strokeWidth:1,stroke:"#000000"},crosshairY:{strokeWidth:1,stroke:"#000000"}},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.measureXY.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[h]},fibonacci:{className:"highcharts-fibonacci",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"fibonacci",type:"fibonacci",typeOptions:{xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:s,y:o},{x:s,y:o}]},labelOptions:{style:{color:"#666666"}}},a.annotationsOptions,a.bindings.fibonacci.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),l]},parallelChannel:{className:"highcharts-parallel-channel",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"parallelChannel",type:"tunnel",typeOptions:{xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:s,y:o},{x:s,y:o}]}},a.annotationsOptions,a.bindings.parallelChannel.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),l]},pitchfork:{className:"highcharts-pitchfork",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=e.value,o=n.value,a=this.chart.options.navigation,r=d({langKey:"pitchfork",type:"pitchfork",typeOptions:{xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value,y:n.value,controlPoint:{style:{fill:"#f21313"}}},{x:s,y:o},{x:s,y:o}],innerBackground:{fill:"rgba(100, 170, 255, 0.8)"}},shapeOptions:{strokeWidth:2}},a.annotationsOptions,a.bindings.pitchfork.annotationsOptions);return this.chart.addAnnotation(r)}},steps:[c(1),c(2)]},verticalCounter:{className:"highcharts-vertical-counter",start:function(t){var i=s(t,this.chart);if(i){this.verticalCounter=this.verticalCounter||0;var e=this.chart.options.navigation,n=d({langKey:"verticalCounter",type:"verticalLine",typeOptions:{point:{x:i.x,y:i.y,xAxis:i.xAxis,yAxis:i.yAxis},label:{offset:i.below?40:-40,text:this.verticalCounter.toString()}},labelOptions:{style:{color:"#666666",fontSize:"0.7em"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},e.annotationsOptions,e.bindings.verticalCounter.annotationsOptions),o=this.chart.addAnnotation(n);this.verticalCounter++,o.options.events.click.call(o,{})}}},timeCycles:{className:"highcharts-time-cycles",start:function(t){var i=s(t,this.chart);if(i){var e=this.chart.options.navigation,n=d({langKey:"timeCycles",type:"timeCycles",typeOptions:{xAxis:i.xAxis,yAxis:i.yAxis,points:[{x:i.x},{x:i.x}],line:{stroke:"rgba(0, 0, 0, 0.75)",fill:"transparent",strokeWidth:2}}},e.annotationsOptions,e.bindings.timeCycles.annotationsOptions),o=this.chart.addAnnotation(n);return o.options.events.click.call(o,{}),o}},steps:[c(1)]},verticalLabel:{className:"highcharts-vertical-label",start:function(t){var i=s(t,this.chart);if(i){var e=this.chart.options.navigation,n=d({langKey:"verticalLabel",type:"verticalLine",typeOptions:{point:{x:i.x,y:i.y,xAxis:i.xAxis,yAxis:i.yAxis},label:{offset:i.below?40:-40}},labelOptions:{style:{color:"#666666",fontSize:"0.7em"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},e.annotationsOptions,e.bindings.verticalLabel.annotationsOptions),o=this.chart.addAnnotation(n);o.options.events.click.call(o,{})}}},verticalArrow:{className:"highcharts-vertical-arrow",start:function(t){var i=s(t,this.chart);if(i){var e=this.chart.options.navigation,n=d({langKey:"verticalArrow",type:"verticalLine",typeOptions:{point:{x:i.x,y:i.y,xAxis:i.xAxis,yAxis:i.yAxis},label:{offset:i.below?40:-40,format:" "},connector:{fill:"none",stroke:i.below?"#f21313":"#06b535"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},e.annotationsOptions,e.bindings.verticalArrow.annotationsOptions),o=this.chart.addAnnotation(n);o.options.events.click.call(o,{})}}},fibonacciTimeZones:{className:"highcharts-fibonacci-time-zones",start:function(t){var i=this.getCoords(t),e=i[0],n=i[1];if(e&&n){var s=this.chart.options.navigation,o=d({type:"fibonacciTimeZones",langKey:"fibonacciTimeZones",typeOptions:{xAxis:e.axis.index,yAxis:n.axis.index,points:[{x:e.value}]}},s.annotationsOptions,s.bindings.fibonacciTimeZones.annotationsOptions);return this.chart.addAnnotation(o)}},steps:[function(t,i){var e=i.options.typeOptions.points,n=e&&e[0].x,s=this.getCoords(t),o=s[0],a=s[1];o&&a&&i.update({typeOptions:{xAxis:o.axis.index,yAxis:a.axis.index,points:[{x:n},{x:o.value}]}})}]},flagCirclepin:{className:"highcharts-flag-circlepin",start:n("circlepin")},flagDiamondpin:{className:"highcharts-flag-diamondpin",start:n("flag")},flagSquarepin:{className:"highcharts-flag-squarepin",start:n("squarepin")},flagSimplepin:{className:"highcharts-flag-simplepin",start:n("nopin")},zoomX:{className:"highcharts-zoom-x",init:function(t){this.chart.update({chart:{zooming:{type:"x"}}}),p(this,"deselectButton",{button:t})}},zoomY:{className:"highcharts-zoom-y",init:function(t){this.chart.update({chart:{zooming:{type:"y"}}}),p(this,"deselectButton",{button:t})}},zoomXY:{className:"highcharts-zoom-xy",init:function(t){this.chart.update({chart:{zooming:{type:"xy"}}}),p(this,"deselectButton",{button:t})}},seriesTypeLine:{className:"highcharts-series-type-line",init:function(t){this.chart.series[0].update({type:"line",useOhlcData:!0}),p(this,"deselectButton",{button:t})}},seriesTypeOhlc:{className:"highcharts-series-type-ohlc",init:function(t){this.chart.series[0].update({type:"ohlc"}),p(this,"deselectButton",{button:t})}},seriesTypeCandlestick:{className:"highcharts-series-type-candlestick",init:function(t){this.chart.series[0].update({type:"candlestick"}),p(this,"deselectButton",{button:t})}},seriesTypeHeikinAshi:{className:"highcharts-series-type-heikinashi",init:function(t){this.chart.series[0].update({type:"heikinashi"}),p(this,"deselectButton",{button:t})}},seriesTypeHLC:{className:"highcharts-series-type-hlc",init:function(t){this.chart.series[0].update({type:"hlc",useOhlcData:!0}),p(this,"deselectButton",{button:t})}},seriesTypeHollowCandlestick:{className:"highcharts-series-type-hollowcandlestick",init:function(t){this.chart.series[0].update({type:"hollowcandlestick"}),p(this,"deselectButton",{button:t})}},fullScreen:{className:"highcharts-full-screen",noDataState:"normal",init:function(t){this.chart.fullscreen&&this.chart.fullscreen.toggle(),p(this,"deselectButton",{button:t})}},currentPriceIndicator:{className:"highcharts-current-price-indicator",init:function(t){var i=this.chart,e=i.series,n=i.stockTools,s=a(i.series);n&&n.guiEnabled&&(e.forEach(function(t){t.update({lastPrice:{enabled:!s},lastVisiblePrice:{enabled:!s,label:{enabled:!0}}},!1)}),i.redraw()),p(this,"deselectButton",{button:t})}},indicators:{className:"highcharts-indicators",init:function(){var t=this;p(t,"showPopup",{formType:"indicators",options:{},onSubmit:function(i){r.call(t,i)}})}},toggleAnnotations:{className:"highcharts-toggle-annotations",init:function(t){var i=this.chart,e=i.stockTools,n=e.getIconsURL();this.toggledAnnotations=!this.toggledAnnotations,(i.annotations||[]).forEach(function(t){t.setVisibility(!this.toggledAnnotations)},this),e&&e.guiEnabled&&(this.toggledAnnotations?t.firstChild.style["background-image"]='url("'+n+'annotations-hidden.svg")':t.firstChild.style["background-image"]='url("'+n+'annotations-visible.svg")'),p(this,"deselectButton",{button:t})}},saveChart:{className:"highcharts-save-chart",noDataState:"normal",init:function(i){var e=this.chart,n=[],s=[],a=[],r=[];e.annotations.forEach(function(t,i){n[i]=t.userOptions}),e.series.forEach(function(t){t.is("sma")?s.push(t.userOptions):"flags"===t.type&&a.push(t.userOptions)}),e.yAxis.forEach(function(t){o(t)&&r.push(t.options)}),t.win.localStorage.setItem("highcharts-chart",JSON.stringify({annotations:n,indicators:s,flags:a,yAxes:r})),p(this,"deselectButton",{button:i})}}}}),e(i,"Stock/StockTools/StockToolsDefaults.js",[],function(){return{lang:{stockTools:{gui:{simpleShapes:"Simple shapes",lines:"Lines",crookedLines:"Crooked lines",measure:"Measure",advanced:"Advanced",toggleAnnotations:"Toggle annotations",verticalLabels:"Vertical labels",flags:"Flags",zoomChange:"Zoom change",typeChange:"Type change",saveChart:"Save chart",indicators:"Indicators",currentPriceIndicator:"Current Price Indicators",zoomX:"Zoom X",zoomY:"Zoom Y",zoomXY:"Zooom XY",fullScreen:"Fullscreen",typeOHLC:"OHLC",typeLine:"Line",typeCandlestick:"Candlestick",typeHLC:"HLC",typeHollowCandlestick:"Hollow Candlestick",typeHeikinAshi:"Heikin Ashi",circle:"Circle",ellipse:"Ellipse",label:"Label",rectangle:"Rectangle",flagCirclepin:"Flag circle",flagDiamondpin:"Flag diamond",flagSquarepin:"Flag square",flagSimplepin:"Flag simple",measureXY:"Measure XY",measureX:"Measure X",measureY:"Measure Y",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowInfinityLine:"Arrow line",horizontalLine:"Horizontal line",verticalLine:"Vertical line",infinityLine:"Infinity line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",fibonacciTimeZones:"Fibonacci Time Zones",pitchfork:"Pitchfork",parallelChannel:"Parallel channel",timeCycles:"Time Cycles"}},navigation:{popup:{circle:"Circle",ellipse:"Ellipse",rectangle:"Rectangle",label:"Label",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowInfinityLine:"Arrow line",horizontalLine:"Horizontal line",verticalLine:"Vertical line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",fibonacciTimeZones:"Fibonacci Time Zones",pitchfork:"Pitchfork",parallelChannel:"Parallel channel",infinityLine:"Infinity line",measure:"Measure",measureXY:"Measure XY",measureX:"Measure X",measureY:"Measure Y",timeCycles:"Time Cycles",flags:"Flags",addButton:"Add",saveButton:"Save",editButton:"Edit",removeButton:"Remove",series:"Series",volume:"Volume",connector:"Connector",innerBackground:"Inner background",outerBackground:"Outer background",crosshairX:"Crosshair X",crosshairY:"Crosshair Y",tunnel:"Tunnel",background:"Background",noFilterMatch:"No match",searchIndicators:"Search Indicators",clearFilter:"✕ clear filter",index:"Index",period:"Period",periods:"Periods",standardDeviation:"Standard deviation",periodTenkan:"Tenkan period",periodSenkouSpanB:"Senkou Span B period",periodATR:"ATR period",multiplierATR:"ATR multiplier",shortPeriod:"Short period",longPeriod:"Long period",signalPeriod:"Signal period",decimals:"Decimals",algorithm:"Algorithm",topBand:"Top band",bottomBand:"Bottom band",initialAccelerationFactor:"Initial acceleration factor",maxAccelerationFactor:"Max acceleration factor",increment:"Increment",multiplier:"Multiplier",ranges:"Ranges",highIndex:"High index",lowIndex:"Low index",deviation:"Deviation",xAxisUnit:"x-axis unit",factor:"Factor",fastAvgPeriod:"Fast average period",slowAvgPeriod:"Slow average period",average:"Average",indicatorAliases:{abands:["Acceleration Bands"],bb:["Bollinger Bands"],dema:["Double Exponential Moving Average"],ema:["Exponential Moving Average"],ikh:["Ichimoku Kinko Hyo"],keltnerchannels:["Keltner Channels"],linearRegression:["Linear Regression"],pivotpoints:["Pivot Points"],pc:["Price Channel"],priceenvelopes:["Price Envelopes"],psar:["Parabolic SAR"],sma:["Simple Moving Average"],supertrend:["Super Trend"],tema:["Triple Exponential Moving Average"],vbp:["Volume by Price"],vwap:["Volume Weighted Moving Average"],wma:["Weighted Moving Average"],zigzag:["Zig Zag"],apo:["Absolute price indicator"],ad:["Accumulation/Distribution"],aroon:["Aroon"],aroonoscillator:["Aroon oscillator"],atr:["Average True Range"],ao:["Awesome oscillator"],cci:["Commodity Channel Index"],chaikin:["Chaikin"],cmf:["Chaikin Money Flow"],cmo:["Chande Momentum Oscillator"],disparityindex:["Disparity Index"],dmi:["Directional Movement Index"],dpo:["Detrended price oscillator"],klinger:["Klinger Oscillator"],linearRegressionAngle:["Linear Regression Angle"],linearRegressionIntercept:["Linear Regression Intercept"],linearRegressionSlope:["Linear Regression Slope"],macd:["Moving Average Convergence Divergence"],mfi:["Money Flow Index"],momentum:["Momentum"],natr:["Normalized Average True Range"],obv:["On-Balance Volume"],ppo:["Percentage Price oscillator"],roc:["Rate of Change"],rsi:["Relative Strength Index"],slowstochastic:["Slow Stochastic"],stochastic:["Stochastic"],trix:["TRIX"],williamsr:["Williams %R"]}}}},stockTools:{gui:{enabled:!0,className:"highcharts-bindings-wrapper",toolbarClassName:"stocktools-toolbar",buttons:["indicators","separator","simpleShapes","lines","crookedLines","measure","advanced","toggleAnnotations","separator","verticalLabels","flags","separator","zoomChange","fullScreen","typeChange","separator","currentPriceIndicator","saveChart"],definitions:{separator:{elementType:"span",symbol:"separator.svg"},simpleShapes:{items:["label","circle","ellipse","rectangle"],circle:{symbol:"circle.svg"},ellipse:{symbol:"ellipse.svg"},rectangle:{symbol:"rectangle.svg"},label:{symbol:"label.svg"}},flags:{items:["flagCirclepin","flagDiamondpin","flagSquarepin","flagSimplepin"],flagSimplepin:{symbol:"flag-basic.svg"},flagDiamondpin:{symbol:"flag-diamond.svg"},flagSquarepin:{symbol:"flag-trapeze.svg"},flagCirclepin:{symbol:"flag-elipse.svg"}},lines:{items:["segment","arrowSegment","ray","arrowRay","line","arrowInfinityLine","horizontalLine","verticalLine"],segment:{symbol:"segment.svg"},arrowSegment:{symbol:"arrow-segment.svg"},ray:{symbol:"ray.svg"},arrowRay:{symbol:"arrow-ray.svg"},line:{symbol:"line.svg"},arrowInfinityLine:{symbol:"arrow-line.svg"},verticalLine:{symbol:"vertical-line.svg"},horizontalLine:{symbol:"horizontal-line.svg"}},crookedLines:{items:["elliott3","elliott5","crooked3","crooked5"],crooked3:{symbol:"crooked-3.svg"},crooked5:{symbol:"crooked-5.svg"},elliott3:{symbol:"elliott-3.svg"},elliott5:{symbol:"elliott-5.svg"}},verticalLabels:{items:["verticalCounter","verticalLabel","verticalArrow"],verticalCounter:{symbol:"vertical-counter.svg"},verticalLabel:{symbol:"vertical-label.svg"},verticalArrow:{symbol:"vertical-arrow.svg"}},advanced:{items:["fibonacci","fibonacciTimeZones","pitchfork","parallelChannel","timeCycles"],pitchfork:{symbol:"pitchfork.svg"},fibonacci:{symbol:"fibonacci.svg"},fibonacciTimeZones:{symbol:"fibonacci-timezone.svg"},parallelChannel:{symbol:"parallel-channel.svg"},timeCycles:{symbol:"time-cycles.svg"}},measure:{items:["measureXY","measureX","measureY"],measureX:{symbol:"measure-x.svg"},measureY:{symbol:"measure-y.svg"},measureXY:{symbol:"measure-xy.svg"}},toggleAnnotations:{symbol:"annotations-visible.svg"},currentPriceIndicator:{symbol:"current-price-show.svg"},indicators:{symbol:"indicators.svg"},zoomChange:{items:["zoomX","zoomY","zoomXY"],zoomX:{symbol:"zoom-x.svg"},zoomY:{symbol:"zoom-y.svg"},zoomXY:{symbol:"zoom-xy.svg"}},typeChange:{items:["typeOHLC","typeLine","typeCandlestick","typeHollowCandlestick","typeHLC","typeHeikinAshi"],typeOHLC:{symbol:"series-ohlc.svg"},typeLine:{symbol:"series-line.svg"},typeCandlestick:{symbol:"series-candlestick.svg"},typeHLC:{symbol:"series-hlc.svg"},typeHeikinAshi:{symbol:"series-heikin-ashi.svg"},typeHollowCandlestick:{symbol:"series-hollow-candlestick.svg"}},fullScreen:{symbol:"fullscreen.svg"},saveChart:{symbol:"save-chart.svg"}}}}}}),e(i,"Stock/StockTools/StockTools.js",[i["Core/Defaults.js"],i["Extensions/Annotations/NavigationBindingsUtilities.js"],i["Stock/StockTools/StockToolsBindings.js"],i["Stock/StockTools/StockToolsDefaults.js"],i["Stock/StockTools/StockToolsUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,n,s,o){var a=t.setOptions,r=i.getAssignedAxis,l=s.isNotNavigatorYAxis,c=s.isPriceIndicatorEnabled,h=o.correctFloat,p=o.defined,d=o.isNumber,u=o.pick;function g(t,i,e,n){var s,o,a,r=0;function l(t){return p(t)&&!d(t)&&t.match("%")}return n&&(a=h(parseFloat(n.top)/100),o=h(parseFloat(n.height)/100)),{positions:t.map(function(n,c){var p=h(l(n.options.height)?parseFloat(n.options.height)/100:n.height/i),u=h(l(n.options.top)?parseFloat(n.options.top)/100:(n.top-n.chart.plotTop)/i);return o?(u>a&&(u-=o),r=Math.max(r,(u||0)+(p||0))):(d(p)||(p=t[c-1].series.every(function(t){return t.is("sma")})?s:e/100),d(u)||(u=r),s=p,r=h(Math.max(r,(u||0)+(p||0)))),{height:100*p,top:100*u}}),allAxesHeight:r}}function v(t){var i=[];return t.forEach(function(e,n){var s=t[n+1];s?i[n]={enabled:!0,controlledAxis:{next:[u(s.options.id,s.index)]}}:i[n]={enabled:!1}}),i}function y(t,i,e,n){return t.forEach(function(s,o){var a=t[o-1];s.top=a?h(a.height+a.top):0,e&&(s.height=h(s.height+n*i))}),t}function f(t){var i=this.chart,e=i.yAxis.filter(l),n=i.plotHeight,s=this.getYAxisPositions(e,n,20,t),o=s.positions,a=s.allAxesHeight,r=this.getYAxisResizers(e);!t&&a<=h(1)?o[o.length-1]={height:20,top:h(100*a-20)}:o.forEach(function(t){t.height=t.height/(100*a)*100,t.top=t.top/(100*a)*100}),o.forEach(function(t,i){e[i].update({height:t.height+"%",top:t.top+"%",resize:r[i],offset:0},!1)})}return{compose:function(t){var i,o=t.prototype;(null===(i=o.utils)||void 0===i?void 0:i.manageIndicators)||(o.getYAxisPositions=g,o.getYAxisResizers=v,o.recalculateYAxisPositions=y,o.resizeYAxes=f,o.utils=o.utils||{},o.utils.indicatorsWithAxes=s.indicatorsWithAxes,o.utils.indicatorsWithVolume=s.indicatorsWithVolume,o.utils.getAssignedAxis=r,o.utils.isPriceIndicatorEnabled=c,o.utils.manageIndicators=s.manageIndicators,a(n),a({navigation:{bindings:e}}))}}}),e(i,"Stock/StockTools/StockToolbar.js",[i["Core/Utilities.js"]],function(t){var i=t.addEvent,e=t.createElement,n=t.css,s=t.fireEvent,o=t.getStyle,a=t.isArray,r=t.merge,l=t.pick,c=function(){function t(t,i,e){this.chart=e,this.options=t,this.lang=i,this.iconsURL=this.getIconsURL(),this.guiEnabled=t.enabled,this.visible=l(t.visible,!0),this.placed=l(t.placed,!1),this.eventsToUnbind=[],this.guiEnabled&&(this.createHTML(),this.init(),this.showHideNavigatorion()),s(this,"afterInit")}return t.prototype.init=function(){var t=this,e=this.lang,n=this.options,s=this.toolbar,o=n.buttons,r=n.definitions,l=s.childNodes;o.forEach(function(n){var o=t.addButton(s,r,n,e);t.eventsToUnbind.push(i(o.buttonWrapper,"click",function(){return t.eraseActiveButtons(l,o.buttonWrapper)})),a(r[n].items)&&t.addSubmenu(o,r[n])})},t.prototype.addSubmenu=function(t,s){var a=this,r=t.submenuArrow,l=t.buttonWrapper,c=o(l,"width"),h=this.wrapper,p=this.listWrapper,d=this.toolbar.childNodes,u=this.submenu=e("ul",{className:"highcharts-submenu-wrapper"},void 0,l);this.addSubmenuItems(l,s),this.eventsToUnbind.push(i(r,"click",function(t){if(t.stopPropagation(),a.eraseActiveButtons(d,l),l.className.indexOf("highcharts-current")>=0)p.style.width=p.startWidth+"px",l.classList.remove("highcharts-current"),u.style.display="none";else{u.style.display="block";var i=u.offsetHeight-l.offsetHeight-3;u.offsetHeight+l.offsetTop>h.offsetHeight&&l.offsetTop>i||(i=0),n(u,{top:-i+"px",left:c+3+"px"}),l.className+=" highcharts-current",p.startWidth=h.offsetWidth,p.style.width=p.startWidth+o(p,"padding-left")+u.offsetWidth+3+"px"}}))},t.prototype.addSubmenuItems=function(t,e){var n,s=this,o=this,a=this.submenu,r=this.lang,l=this.listWrapper;e.items.forEach(function(c){n=s.addButton(a,e,c,r),s.eventsToUnbind.push(i(n.mainButton,"click",function(){o.switchSymbol(this,t,!0),l.style.width=l.startWidth+"px",a.style.display="none"}))});var c=a.querySelectorAll("li > .highcharts-menu-item-btn")[0];this.switchSymbol(c,!1)},t.prototype.eraseActiveButtons=function(t,i,e){[].forEach.call(t,function(t){t!==i&&(t.classList.remove("highcharts-current"),t.classList.remove("highcharts-active"),(e=t.querySelectorAll(".highcharts-submenu-wrapper")).length>0&&(e[0].style.display="none"))})},t.prototype.addButton=function(i,n,s,o){void 0===o&&(o={});var a=n[s],r=a.items,c=t.prototype.classMapping,h=a.className||"",p=e("li",{className:l(c[s],"")+" "+h,title:o[s]||s},void 0,i),d=e(a.elementType||"button",{className:"highcharts-menu-item-btn"},void 0,p);if(r&&r.length){var u=e("button",{className:"highcharts-submenu-item-arrow highcharts-arrow-right"},void 0,p);return u.style.backgroundImage="url("+this.iconsURL+"arrow-bottom.svg)",{buttonWrapper:p,mainButton:d,submenuArrow:u}}return d.style.backgroundImage="url("+this.iconsURL+a.symbol+")",{buttonWrapper:p,mainButton:d}},t.prototype.addNavigation=function(){var t=this.wrapper;this.arrowWrapper=e("div",{className:"highcharts-arrow-wrapper"}),this.arrowUp=e("div",{className:"highcharts-arrow-up"},void 0,this.arrowWrapper),this.arrowUp.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)",this.arrowDown=e("div",{className:"highcharts-arrow-down"},void 0,this.arrowWrapper),this.arrowDown.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)",t.insertBefore(this.arrowWrapper,t.childNodes[0]),this.scrollButtons()},t.prototype.scrollButtons=function(){var t=this.wrapper,e=this.toolbar,n=.1*t.offsetHeight,s=0;this.eventsToUnbind.push(i(this.arrowUp,"click",function(){s>0&&(s-=n,e.style.marginTop=-s+"px")})),this.eventsToUnbind.push(i(this.arrowDown,"click",function(){t.offsetHeight+s<=e.offsetHeight+n&&(s+=n,e.style.marginTop=-s+"px")}))},t.prototype.createHTML=function(){var t,n,s=this.chart,o=this.options,a=s.container,r=s.options.navigation,l=r&&r.bindingsClassName,c=this.wrapper=e("div",{className:"highcharts-stocktools-wrapper "+o.className+" "+l});a.appendChild(c),["mousedown","mousemove","click","touchstart"].forEach(function(t){i(c,t,function(t){return t.stopPropagation()})}),i(c,"mouseover",function(t){var i;return null===(i=s.pointer)||void 0===i?void 0:i.onContainerMouseLeave(t)}),this.toolbar=n=e("ul",{className:"highcharts-stocktools-toolbar "+o.toolbarClassName}),this.listWrapper=t=e("div",{className:"highcharts-menu-wrapper"}),c.insertBefore(t,c.childNodes[0]),t.insertBefore(n,t.childNodes[0]),this.showHideToolbar(),this.addNavigation()},t.prototype.showHideNavigatorion=function(){this.visible&&this.toolbar.offsetHeight>this.wrapper.offsetHeight-50?this.arrowWrapper.style.display="block":(this.toolbar.style.marginTop="0px",this.arrowWrapper.style.display="none")},t.prototype.showHideToolbar=function(){var t=this.chart,n=this.wrapper,s=this.listWrapper,a=this.submenu,r=this.showhideBtn=e("div",{className:"highcharts-toggle-toolbar highcharts-arrow-left"},void 0,n),l=this.visible;r.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)",l?(n.style.height="100%",r.style.top=o(s,"padding-top")+"px",r.style.left=n.offsetWidth+o(s,"padding-left")+"px"):(a&&(a.style.display="none"),r.style.left="0px",l=this.visible=!1,s.classList.add("highcharts-hide"),r.classList.toggle("highcharts-arrow-right"),n.style.height=r.offsetHeight+"px"),this.eventsToUnbind.push(i(r,"click",function(){t.update({stockTools:{gui:{visible:!l,placed:!0}}})}))},t.prototype.switchSymbol=function(t,i){var e=t.parentNode,n=e.className,s=e.parentNode.parentNode;!(n.indexOf("highcharts-disabled-btn")>-1)&&(s.className="",n&&s.classList.add(n.trim()),s.querySelectorAll(".highcharts-menu-item-btn")[0].style.backgroundImage=t.style.backgroundImage,i&&this.toggleButtonActiveClass(s))},t.prototype.toggleButtonActiveClass=function(t){var i=t.classList;i.contains("highcharts-active")?i.remove("highcharts-active"):i.add("highcharts-active")},t.prototype.unselectAllButtons=function(t){var i=t.parentNode.querySelectorAll(".highcharts-active");[].forEach.call(i,function(i){i!==t&&i.classList.remove("highcharts-active")})},t.prototype.update=function(t,i){r(!0,this.chart.options.stockTools,t),this.destroy(),this.chart.setStockTools(t),this.chart.navigationBindings&&this.chart.navigationBindings.update(),this.chart.isDirtyBox=!0,l(i,!0)&&this.chart.redraw()},t.prototype.destroy=function(){var t=this.wrapper,i=t&&t.parentNode;this.eventsToUnbind.forEach(function(t){return t()}),i&&i.removeChild(t)},t.prototype.redraw=function(){this.showHideNavigatorion()},t.prototype.getIconsURL=function(){return this.chart.options.navigation.iconsURL||this.options.iconsURL||"https://code.highcharts.com/11.4.0/gfx/stock-icons/"},t}();return c.prototype.classMapping={circle:"highcharts-circle-annotation",ellipse:"highcharts-ellipse-annotation",rectangle:"highcharts-rectangle-annotation",label:"highcharts-label-annotation",segment:"highcharts-segment",arrowSegment:"highcharts-arrow-segment",ray:"highcharts-ray",arrowRay:"highcharts-arrow-ray",line:"highcharts-infinity-line",arrowInfinityLine:"highcharts-arrow-infinity-line",verticalLine:"highcharts-vertical-line",horizontalLine:"highcharts-horizontal-line",crooked3:"highcharts-crooked3",crooked5:"highcharts-crooked5",elliott3:"highcharts-elliott3",elliott5:"highcharts-elliott5",pitchfork:"highcharts-pitchfork",fibonacci:"highcharts-fibonacci",fibonacciTimeZones:"highcharts-fibonacci-time-zones",parallelChannel:"highcharts-parallel-channel",measureX:"highcharts-measure-x",measureY:"highcharts-measure-y",measureXY:"highcharts-measure-xy",timeCycles:"highcharts-time-cycles",verticalCounter:"highcharts-vertical-counter",verticalLabel:"highcharts-vertical-label",verticalArrow:"highcharts-vertical-arrow",currentPriceIndicator:"highcharts-current-price-indicator",indicators:"highcharts-indicators",flagCirclepin:"highcharts-flag-circlepin",flagDiamondpin:"highcharts-flag-diamondpin",flagSquarepin:"highcharts-flag-squarepin",flagSimplepin:"highcharts-flag-simplepin",zoomX:"highcharts-zoom-x",zoomY:"highcharts-zoom-y",zoomXY:"highcharts-zoom-xy",typeLine:"highcharts-series-type-line",typeOHLC:"highcharts-series-type-ohlc",typeHLC:"highcharts-series-type-hlc",typeCandlestick:"highcharts-series-type-candlestick",typeHollowCandlestick:"highcharts-series-type-hollowcandlestick",typeHeikinAshi:"highcharts-series-type-heikinashi",fullScreen:"highcharts-full-screen",toggleAnnotations:"highcharts-toggle-annotations",saveChart:"highcharts-save-chart",separator:"highcharts-separator"},c}),e(i,"Stock/StockTools/StockToolsGui.js",[i["Core/Defaults.js"],i["Stock/StockTools/StockToolsDefaults.js"],i["Stock/StockTools/StockToolbar.js"],i["Core/Utilities.js"]],function(t,i,e,n){var s=t.setOptions,o=n.addEvent,a=n.getStyle,r=n.merge,l=n.pick;function c(t){var i=this.options,n=i.lang,s=r(i.stockTools&&i.stockTools.gui,t&&t.gui),o=n&&n.stockTools&&n.stockTools.gui;this.stockTools=new e(s,o,this),this.stockTools.guiEnabled&&(this.isDirtyBox=!0)}function h(){this.setStockTools()}function p(){if(this.stockTools){var t=this.options.chart,i=this.stockTools.listWrapper,e=i&&(i.startWidth+a(i,"padding-left")+a(i,"padding-right")||i.offsetWidth),n=!1;if(e&&e<this.plotWidth){var s=l(t.spacingLeft,t.spacing&&t.spacing[3],0)+e,o=s-this.spacingBox.x;this.spacingBox.x=s,this.spacingBox.width-=o,n=!0}else 0===e&&(n=!0);e!==this.stockTools.prevOffsetWidth&&(this.stockTools.prevOffsetWidth=e,n&&(this.isDirtyLegend=!0))}}function d(){this.stockTools&&this.stockTools.destroy()}function u(){var t=this.stockTools&&this.stockTools.listWrapper,i=t&&(t.startWidth+a(t,"padding-left")+a(t,"padding-right")||t.offsetWidth);i&&i<this.plotWidth&&(this.plotLeft+=i,this.spacing[3]+=i)}function g(){this.stockTools&&this.stockTools.guiEnabled&&this.stockTools.redraw()}function v(){var t,i,e=this.stockTools,n=e&&e.toolbar&&e.toolbar.querySelector(".highcharts-current-price-indicator");e&&this.navigationBindings&&this.options.series&&n&&((null===(i=null===(t=this.navigationBindings.utils)||void 0===t?void 0:t.isPriceIndicatorEnabled)||void 0===i?void 0:i.call(t,this.series))?n.firstChild.style["background-image"]='url("'+e.getIconsURL()+'current-price-hide.svg")':n.firstChild.style["background-image"]='url("'+e.getIconsURL()+'current-price-show.svg")')}function y(t){var i=this.chart.stockTools;if(i&&i.guiEnabled){var e=t.button;e.parentNode.className.indexOf("highcharts-submenu-wrapper")>=0&&(e=e.parentNode.parentNode),i.toggleButtonActiveClass(e)}}function f(t){var i=this.chart.stockTools;if(i&&i.guiEnabled){var e=t.button;i.unselectAllButtons(t.button),e.parentNode.className.indexOf("highcharts-submenu-wrapper")>=0&&(e=e.parentNode.parentNode),i.toggleButtonActiveClass(e)}}return{compose:function(t,e){var n=t.prototype;n.setStockTools||(o(t,"afterGetContainer",h),o(t,"beforeRedraw",p),o(t,"beforeRender",p),o(t,"destroy",d),o(t,"getMargins",u,{order:0}),o(t,"redraw",g),o(t,"render",v),n.setStockTools=c,o(e,"deselectButton",y),o(e,"selectButton",f),s(i))}}}),e(i,"masters/modules/stock-tools.src.js",[i["Core/Globals.js"],i["Extensions/Annotations/NavigationBindings.js"],i["Stock/StockTools/StockTools.js"],i["Stock/StockTools/StockToolsGui.js"],i["Stock/StockTools/StockToolbar.js"]],function(t,i,e,n,s){return t.NavigationBindings=t.NavigationBindings||i,t.Toolbar=s,e.compose(t.NavigationBindings),n.compose(t.Chart,t.NavigationBindings),t})});