<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <?php echo form_open_multipart($locale . "/volontaire/save", null, ['id' => $volontaire->id]); ?>
        <div class="row" style="margin-top:10px">
            <div class="col-md-9">
                <h2 class="text-bold"><?= \auth()->user()->nom . ", " . \auth()->user()->prenom ?></h2>

                <?php
                if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message') . "</div>";
                }
                ?>               

                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">
                            Informations de base
                        </h3>
                        <p class='text-bold float-right'>
                            <font color='red'>*</font> Champ est obligatoire
                        </p>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <?php ?>
                                <?= form_label("Titre"); ?>
                                <?php
                                $titre = [
                                    'type'  => 'text',
                                    'name'  => 'titre',
                                    'id'    => 'titre',
                                    'value' => set_value('titre', $volontaire->titre),
                                    'placeholder' => "Ex.: Pr, Dr, Msc, Ir, Volontaire, ...",
                                    'class' => 'form-control',
                                ];

                                echo form_input($titre);
                                ?>
                                <?= !empty(validation_show_error('titre')) ? "<p class='text-danger'>" . validation_show_error('titre') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-4">
                                <?php ?>
                                <?= form_label("Nom de famille <font color='red'>*</font>"); ?>
                                <?php
                                $nom = [
                                    'type'  => 'text',
                                    'name'  => 'nom',
                                    'id'    => 'nom',
                                    'value' => set_value('nom', $volontaire->nom),
                                    'placeholder' => "Nom",
                                    'class' => 'form-control',
                                ];

                                echo form_input($nom);
                                ?>
                                <?= !empty(validation_show_error('nom')) ? "<p class='text-danger'>" . validation_show_error('nom') . "</p>" : "" ?>
                            </div>
                            <div class="col-md-4">
                                <?= form_label("Prénoms <font color='red'>*</font>"); ?>
                                <?php
                                $prenom = [
                                    'type'  => 'text',
                                    'name'  => 'prenom',
                                    'id'    => 'prenom',
                                    'value' => set_value('prenom', $volontaire->prenom),
                                    'placeholder' => "Prénoms",
                                    'class' => 'form-control',
                                ];

                                echo form_input($prenom);
                                ?>
                                <?= !empty(validation_show_error('prenom')) ? "<p class='text-danger'>" . validation_show_error('prenom') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-4">
                                <?= form_label("Surnom"); ?>
                                <?php
                                $surnom = [
                                    'type'  => 'text',
                                    'name'  => 'surnom',
                                    'id'    => 'surnom',
                                    'value' => set_value('surnom', $volontaire->surnom),
                                    'placeholder' => "Nom d'appel",
                                    'class' => 'form-control',
                                ];

                                echo form_input($surnom);
                                ?>
                                <?= !empty(validation_show_error('surnom')) ? "<p class='text-danger'>" . validation_show_error('surnom') . "</p>" : "" ?>

                            </div>

                            <?php

                            $br = [
                                'type'  => 'hidden',
                                'name'  => 'branche_id_load',
                                'id'    => 'branche_id_load',
                                'value' => $volontaire->brancheId,
                            ];

                            echo form_input($br);

                            $cm = [
                                'type'  => 'hidden',
                                'name'  => 'commune_id_load',
                                'id'    => 'commune_id_load',
                                'value' => $volontaire->communeId,
                            ];

                            echo form_input($cm);

                            $zn = [
                                'type'  => 'hidden',
                                'name'  => 'zone_id_load',
                                'id'    => 'zone_id_load',
                                'value' => $volontaire->zoneId,
                            ];

                            echo form_input($zn);

                            $cl = [
                                'type'  => 'hidden',
                                'name'  => 'colline_id_load',
                                'id'    => 'colline_id_load',
                                'value' => $volontaire->collineId,
                            ];

                            echo form_input($cl);
                            ?>

                            <div class="col-md-4">
                                <?= form_label("Branche"); ?>
                                <?php
                                echo form_dropdown('brancheId', $branches, set_value('brancheId', $volontaire->brancheId), "class = 'form-control' id='brancheId'");
                                ?>
                            </div>

                            <div class="col-md-4">
                                <?= form_label("Commune"); ?>
                                <?php
                                echo form_dropdown('communeId', [], set_value('communeId', $volontaire->communeId), "class = 'form-control' id='communeId'");
                                ?>
                            </div>

                            <div class="col-md-4">
                                <?= form_label("Zone"); ?>
                                <?php
                                echo form_dropdown('zoneId', [], set_value('zoneId', $volontaire->zoneId), "class = 'form-control' id='zoneId'");
                                ?>
                            </div>

                            <div class="col-md-4">
                                <?= form_label("Colline"); ?>
                                <?php
                                echo form_dropdown('collineId', [], set_value('collineId', $volontaire->collineId), "class = 'form-control' id='collineId'");
                                ?>
                            </div>

                            <div class="col-md-4">
                                <?= form_label("Genre <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('genre', $genres, set_value('genre', $volontaire->genre), "class = 'form-control'");
                                ?>
                                <?= !empty(validation_show_error('genre')) ? "<p class='text-danger'>" . validation_show_error('genre') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-4">
                                <?= form_label("Téléphone <font color='red'>*</font>"); ?>
                                <?php
                                $telephone = [
                                    'type'  => 'text',
                                    'name'  => 'telephone',
                                    'id'    => 'telephone',
                                    'value' => set_value('telephone', $volontaire->telephone),
                                    'placeholder' => "Téléphone",
                                    'class' => 'form-control',
                                ];

                                echo form_input($telephone);
                                ?>
                                <?= !empty(validation_show_error('telephone')) ? "<p class='text-danger'>" . validation_show_error('telephone') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-4">
                                <?= form_label("E-mail <font color='red'>*</font>"); ?>
                                <?php
                                $email = [
                                    'type'  => 'text',
                                    'name'  => 'email',
                                    'id'    => 'email',
                                    'value' => set_value('email', $volontaire->email),
                                    'placeholder' => "E-mail",
                                    'class' => 'form-control',
                                ];

                                echo form_input($email);
                                ?>
                                <?= !empty(validation_show_error('email')) ? "<p class='text-danger'>" . validation_show_error('email') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-4">
                                <?= form_label("Date de naissance <font color='red'>*</font>"); ?>
                                <?php $date = $volontaire->dateNaissance ? $volontaire->dateNaissance : set_value('dateNaissance') ?>
                                <div class="input-group date" id="dateNaissance" data-target-input="nearest">
                                    <?= form_input('dateNaissance', $date, "class='form-control datetimepicker-input', id='dateNaissance' placeholder='" . lang("Employer.employer_form_dateNaissance") . "'") ?>
                                    <div class="input-group-append" data-target="#dateNaissance" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('dateNaissance')) ? "<p class='text-danger'>" . validation_show_error('dateNaissance') . "</p>" : "" ?>

                            </div>
                            <div class="col-md-4">
                                <?= form_label("Nationalite <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('nationaliteId', $pays, set_value('nationaliteId', $volontaire->nationaliteId), "class = 'form-control' id='nationaliteId'");
                                ?>
                                <?= !empty(validation_show_error('nationaliteId')) ? "<p class='text-danger'>" . validation_show_error('nationaliteId') . "</p>" : "" ?>

                            </div>


                            <div class="col-md-4">
                                <?= form_label("Profession <font color='red'>*</font>"); ?>

                                <?php
                                echo form_dropdown('professionId', $professions, set_value('professionId', $volontaire->professionId), "class = 'form-control' id='professionId'");
                                ?>
                                <?= !empty(validation_show_error('professionId')) ? "<p class='text-danger'>" . validation_show_error('professionId') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-4">
                                <?= form_label("Employeur"); ?>
                                <?php
                                $employeur = [
                                    'type'  => 'text',
                                    'name'  => 'employeur',
                                    'id'    => 'employeur',
                                    'value' => set_value('employeur', $volontaire->employeur),
                                    'placeholder' => "Employeur",
                                    'class' => 'form-control',
                                ];

                                echo form_input($employeur);
                                ?>
                                <?= !empty(validation_show_error('employeur')) ? "<p class='text-danger'>" . validation_show_error('employeur') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-4">
                                <?= form_label("Fonction"); ?>
                                <?php
                                $fonction = [
                                    'type'  => 'text',
                                    'name'  => 'fonction',
                                    'id'    => 'fonction',
                                    'value' => set_value('fonction', $volontaire->fonction),
                                    'placeholder' => "Fonction",
                                    'class' => 'form-control',
                                ];

                                echo form_input($fonction);
                                ?>
                                <?= !empty(validation_show_error('fonction')) ? "<p class='text-danger'>" . validation_show_error('fonction') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-4">
                                <?= form_label("Est staff de CRB ? <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('estStaff', $estStaff, set_value('estStaff', $volontaire->estStaff), "class = 'form-control' id='estStaff'");
                                ?>
                                <?= !empty(validation_show_error('estStaff')) ? "<p class='text-danger'>" . validation_show_error('estStaff') . "</p>" : "" ?>
                            </div>


                            <div class="col-md-4">
                                <?= form_label("Appartenir à une section jeunesse ? <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('estSectionJeunesse', $ouiNon, set_value('estSectionJeunesse', $volontaire->estSectionJeunesse), "class = 'form-control' id='estSectionJeunesse'");
                                ?>
                                <?= !empty(validation_show_error('estSectionJeunesse')) ? "<p class='text-danger'>" . validation_show_error('estSectionJeunesse') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-4" id='divSection'>
                                <?= form_label("Preciser la section"); ?>
                                <?php
                                $sectionJeunesse = [
                                    'type'  => 'text',
                                    'name'  => 'sectionJeunesse',
                                    'id'    => 'sectionJeunesse',
                                    'value' => set_value('sectionJeunesse', $volontaire->sectionJeunesse),
                                    'placeholder' => "Section",
                                    'class' => 'form-control',
                                ];

                                echo form_input($sectionJeunesse);
                                ?>
                                <?= !empty(validation_show_error('sectionJeunesse')) ? "<p class='text-danger'>" . validation_show_error('sectionJeunesse') . "</p>" : "" ?>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-3">
                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Actions</h3>
                    </div>

                    <div class="card-body">
                        <?php
                        echo form_submit("mysubmit", "Enregistrer les modifications", "class='btn btn-primary btn-sm btn-block mt-2'");
                        ?>
                        <?php
                        echo anchor($locale . '/volontaire/identite/pdf', 'Imprimer', "target='_blank' class='btn btn-success btn-sm btn-block btn-sm mt-2'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>

                <?php echo form_open_multipart($locale . "/volontaire/identite/photo", null, ['id' => $volontaire->id]); ?>
                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Photo de profil</h3>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <?= form_label("Photo de profil"); ?>
                            <?php

                            $passportImagePath = [
                                'type'  => 'file',
                                'name'  => 'passportImagePath',
                                'id'    => 'passportImagePath',
                                'class' => 'form-control',
                            ];

                            echo form_upload($passportImagePath);

                            ?>
                            <?= !empty(validation_show_error('passportImagePath')) ? "<p class='text-danger'>" . validation_show_error('passportImagePath') . "</p>" : "" ?>

                        </div>

                        <?php
                        echo form_submit("mysubmit", "Téléverser", "class='btn btn-primary btn-sm btn-block mt-2'");
                        ?>
                    </div>
                    <?php echo form_close(); ?>

                </div>
            </div>

    </section>
</div>


<?= $this->endSection(); ?>